/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.files.FileMetadata;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class ListRevisionsResult {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final boolean isDeleted;
    protected final List<FileMetadata> entries;

    public ListRevisionsResult(boolean isDeleted, List<FileMetadata> entries) {
        this.isDeleted = isDeleted;
        if (entries == null) {
            throw new IllegalArgumentException("Required value for 'entries' is null");
        }
        for (FileMetadata x : entries) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'entries' is null");
        }
        this.entries = entries;
    }

    public boolean getIsDeleted() {
        return this.isDeleted;
    }

    public List<FileMetadata> getEntries() {
        return this.entries;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.isDeleted, this.entries});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            ListRevisionsResult other = (ListRevisionsResult)obj;
            return this.isDeleted == other.isDeleted && (this.entries == other.entries || this.entries.equals(other.entries));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<ListRevisionsResult> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(ListRevisionsResult.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(ListRevisionsResult.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<ListRevisionsResult> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public ListRevisionsResult deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            Boolean isDeleted = null;
            ArrayList<FileMetadata> entries = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("is_deleted".equals(_field)) {
                    isDeleted = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("entries".equals(_field)) {
                    Deserializer.expectArrayStart(_p);
                    entries = new ArrayList<FileMetadata>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        FileMetadata _x = null;
                        _x = _p.readValueAs(FileMetadata.class);
                        _p.nextToken();
                        entries.add(_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (isDeleted == null) {
                throw new JsonParseException(_p, "Required field \"is_deleted\" is missing.");
            }
            if (entries == null) {
                throw new JsonParseException(_p, "Required field \"entries\" is missing.");
            }
            return new ListRevisionsResult(isDeleted, entries);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<ListRevisionsResult> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(ListRevisionsResult.class);
        }

        public Serializer(boolean unwrapping) {
            super(ListRevisionsResult.class, unwrapping);
        }

        @Override
        protected JsonSerializer<ListRevisionsResult> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(ListRevisionsResult value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("is_deleted", value.isDeleted);
            g.writeObjectField("entries", value.entries);
        }
    }
}

