/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.dropbox.core.v2.files.WriteConflictError;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class WriteError {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    public static final WriteError NO_WRITE_PERMISSION = new WriteError(Tag.NO_WRITE_PERMISSION, null, null);
    public static final WriteError INSUFFICIENT_SPACE = new WriteError(Tag.INSUFFICIENT_SPACE, null, null);
    public static final WriteError DISALLOWED_NAME = new WriteError(Tag.DISALLOWED_NAME, null, null);
    public static final WriteError OTHER = new WriteError(Tag.OTHER, null, null);
    private final Tag tag;
    private final String malformedPathValue;
    private final WriteConflictError conflictValue;

    private WriteError(Tag tag, String malformedPathValue, WriteConflictError conflictValue) {
        this.tag = tag;
        this.malformedPathValue = malformedPathValue;
        this.conflictValue = conflictValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isMalformedPath() {
        return this.tag == Tag.MALFORMED_PATH;
    }

    public static WriteError malformedPath(String value) {
        return new WriteError(Tag.MALFORMED_PATH, value, null);
    }

    public static WriteError malformedPath() {
        return WriteError.malformedPath(null);
    }

    public String getMalformedPathValue() {
        if (this.tag != Tag.MALFORMED_PATH) {
            throw new IllegalStateException("Invalid tag: required Tag.MALFORMED_PATH, but was Tag." + this.tag.name());
        }
        return this.malformedPathValue;
    }

    public boolean isConflict() {
        return this.tag == Tag.CONFLICT;
    }

    public static WriteError conflict(WriteConflictError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new WriteError(Tag.CONFLICT, null, value);
    }

    public WriteConflictError getConflictValue() {
        if (this.tag != Tag.CONFLICT) {
            throw new IllegalStateException("Invalid tag: required Tag.CONFLICT, but was Tag." + this.tag.name());
        }
        return this.conflictValue;
    }

    public boolean isNoWritePermission() {
        return this.tag == Tag.NO_WRITE_PERMISSION;
    }

    public boolean isInsufficientSpace() {
        return this.tag == Tag.INSUFFICIENT_SPACE;
    }

    public boolean isDisallowedName() {
        return this.tag == Tag.DISALLOWED_NAME;
    }

    public boolean isOther() {
        return this.tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.malformedPathValue, this.conflictValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof WriteError) {
            WriteError other = (WriteError)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case MALFORMED_PATH: {
                    return this.malformedPathValue == other.malformedPathValue || this.malformedPathValue != null && this.malformedPathValue.equals(other.malformedPathValue);
                }
                case CONFLICT: {
                    return this.conflictValue == other.conflictValue || this.conflictValue.equals((Object)other.conflictValue);
                }
                case NO_WRITE_PERMISSION: {
                    return true;
                }
                case INSUFFICIENT_SPACE: {
                    return true;
                }
                case DISALLOWED_NAME: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<WriteError, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(WriteError.class, Deserializer.getTagMapping(), Tag.OTHER, new Class[0]);
        }

        @Override
        public WriteError deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case MALFORMED_PATH: {
                    if (Deserializer.isObjectEnd(_p)) {
                        return WriteError.malformedPath();
                    }
                    String value = null;
                    Deserializer.expectField(_p, "malformed_path");
                    value = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    return WriteError.malformedPath(value);
                }
                case CONFLICT: {
                    WriteConflictError value = null;
                    Deserializer.expectField(_p, "conflict");
                    value = _p.readValueAs(WriteConflictError.class);
                    _p.nextToken();
                    return WriteError.conflict(value);
                }
                case NO_WRITE_PERMISSION: {
                    return NO_WRITE_PERMISSION;
                }
                case INSUFFICIENT_SPACE: {
                    return INSUFFICIENT_SPACE;
                }
                case DISALLOWED_NAME: {
                    return DISALLOWED_NAME;
                }
                case OTHER: {
                    return OTHER;
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("malformed_path", Tag.MALFORMED_PATH);
            values.put("conflict", Tag.CONFLICT);
            values.put("no_write_permission", Tag.NO_WRITE_PERMISSION);
            values.put("insufficient_space", Tag.INSUFFICIENT_SPACE);
            values.put("disallowed_name", Tag.DISALLOWED_NAME);
            values.put("other", Tag.OTHER);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<WriteError> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(WriteError.class, new Class[0]);
        }

        @Override
        public void serialize(WriteError value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case MALFORMED_PATH: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "malformed_path");
                    if (value.malformedPathValue != null) {
                        g.writeObjectField("malformed_path", value.malformedPathValue);
                    }
                    g.writeEndObject();
                    break;
                }
                case CONFLICT: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "conflict");
                    g.writeObjectField("conflict", (Object)value.conflictValue);
                    g.writeEndObject();
                    break;
                }
                case NO_WRITE_PERMISSION: {
                    g.writeString("no_write_permission");
                    break;
                }
                case INSUFFICIENT_SPACE: {
                    g.writeString("insufficient_space");
                    break;
                }
                case DISALLOWED_NAME: {
                    g.writeString("disallowed_name");
                    break;
                }
                case OTHER: {
                    g.writeString("other");
                }
            }
        }
    }

    public static enum Tag {
        MALFORMED_PATH,
        CONFLICT,
        NO_WRITE_PERMISSION,
        INSUFFICIENT_SPACE,
        DISALLOWED_NAME,
        OTHER;

    }
}

