/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class AddMemberSelectorError {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    public static final AddMemberSelectorError GROUP_DELETED = new AddMemberSelectorError(Tag.GROUP_DELETED, null, null, null);
    public static final AddMemberSelectorError GROUP_NOT_ON_TEAM = new AddMemberSelectorError(Tag.GROUP_NOT_ON_TEAM, null, null, null);
    public static final AddMemberSelectorError OTHER = new AddMemberSelectorError(Tag.OTHER, null, null, null);
    private final Tag tag;
    private final String invalidDropboxIdValue;
    private final String invalidEmailValue;
    private final String unverifiedDropboxIdValue;

    private AddMemberSelectorError(Tag tag, String invalidDropboxIdValue, String invalidEmailValue, String unverifiedDropboxIdValue) {
        this.tag = tag;
        this.invalidDropboxIdValue = invalidDropboxIdValue;
        this.invalidEmailValue = invalidEmailValue;
        this.unverifiedDropboxIdValue = unverifiedDropboxIdValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isInvalidDropboxId() {
        return this.tag == Tag.INVALID_DROPBOX_ID;
    }

    public static AddMemberSelectorError invalidDropboxId(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() < 1) {
            throw new IllegalArgumentException("String is shorter than 1");
        }
        return new AddMemberSelectorError(Tag.INVALID_DROPBOX_ID, value, null, null);
    }

    public String getInvalidDropboxIdValue() {
        if (this.tag != Tag.INVALID_DROPBOX_ID) {
            throw new IllegalStateException("Invalid tag: required Tag.INVALID_DROPBOX_ID, but was Tag." + this.tag.name());
        }
        return this.invalidDropboxIdValue;
    }

    public boolean isInvalidEmail() {
        return this.tag == Tag.INVALID_EMAIL;
    }

    public static AddMemberSelectorError invalidEmail(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 255) {
            throw new IllegalArgumentException("String is longer than 255");
        }
        if (!Pattern.matches("^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*.[A-Za-z]{2,15}$", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new AddMemberSelectorError(Tag.INVALID_EMAIL, null, value, null);
    }

    public String getInvalidEmailValue() {
        if (this.tag != Tag.INVALID_EMAIL) {
            throw new IllegalStateException("Invalid tag: required Tag.INVALID_EMAIL, but was Tag." + this.tag.name());
        }
        return this.invalidEmailValue;
    }

    public boolean isUnverifiedDropboxId() {
        return this.tag == Tag.UNVERIFIED_DROPBOX_ID;
    }

    public static AddMemberSelectorError unverifiedDropboxId(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() < 1) {
            throw new IllegalArgumentException("String is shorter than 1");
        }
        return new AddMemberSelectorError(Tag.UNVERIFIED_DROPBOX_ID, null, null, value);
    }

    public String getUnverifiedDropboxIdValue() {
        if (this.tag != Tag.UNVERIFIED_DROPBOX_ID) {
            throw new IllegalStateException("Invalid tag: required Tag.UNVERIFIED_DROPBOX_ID, but was Tag." + this.tag.name());
        }
        return this.unverifiedDropboxIdValue;
    }

    public boolean isGroupDeleted() {
        return this.tag == Tag.GROUP_DELETED;
    }

    public boolean isGroupNotOnTeam() {
        return this.tag == Tag.GROUP_NOT_ON_TEAM;
    }

    public boolean isOther() {
        return this.tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.invalidDropboxIdValue, this.invalidEmailValue, this.unverifiedDropboxIdValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AddMemberSelectorError) {
            AddMemberSelectorError other = (AddMemberSelectorError)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case INVALID_DROPBOX_ID: {
                    return this.invalidDropboxIdValue == other.invalidDropboxIdValue || this.invalidDropboxIdValue.equals(other.invalidDropboxIdValue);
                }
                case INVALID_EMAIL: {
                    return this.invalidEmailValue == other.invalidEmailValue || this.invalidEmailValue.equals(other.invalidEmailValue);
                }
                case UNVERIFIED_DROPBOX_ID: {
                    return this.unverifiedDropboxIdValue == other.unverifiedDropboxIdValue || this.unverifiedDropboxIdValue.equals(other.unverifiedDropboxIdValue);
                }
                case GROUP_DELETED: {
                    return true;
                }
                case GROUP_NOT_ON_TEAM: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<AddMemberSelectorError, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(AddMemberSelectorError.class, Deserializer.getTagMapping(), Tag.OTHER, new Class[0]);
        }

        @Override
        public AddMemberSelectorError deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case INVALID_DROPBOX_ID: {
                    String value = null;
                    Deserializer.expectField(_p, "invalid_dropbox_id");
                    value = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    return AddMemberSelectorError.invalidDropboxId(value);
                }
                case INVALID_EMAIL: {
                    String value = null;
                    Deserializer.expectField(_p, "invalid_email");
                    value = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    return AddMemberSelectorError.invalidEmail(value);
                }
                case UNVERIFIED_DROPBOX_ID: {
                    String value = null;
                    Deserializer.expectField(_p, "unverified_dropbox_id");
                    value = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    return AddMemberSelectorError.unverifiedDropboxId(value);
                }
                case GROUP_DELETED: {
                    return GROUP_DELETED;
                }
                case GROUP_NOT_ON_TEAM: {
                    return GROUP_NOT_ON_TEAM;
                }
                case OTHER: {
                    return OTHER;
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("invalid_dropbox_id", Tag.INVALID_DROPBOX_ID);
            values.put("invalid_email", Tag.INVALID_EMAIL);
            values.put("unverified_dropbox_id", Tag.UNVERIFIED_DROPBOX_ID);
            values.put("group_deleted", Tag.GROUP_DELETED);
            values.put("group_not_on_team", Tag.GROUP_NOT_ON_TEAM);
            values.put("other", Tag.OTHER);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<AddMemberSelectorError> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(AddMemberSelectorError.class, new Class[0]);
        }

        @Override
        public void serialize(AddMemberSelectorError value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case INVALID_DROPBOX_ID: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "invalid_dropbox_id");
                    g.writeObjectField("invalid_dropbox_id", value.invalidDropboxIdValue);
                    g.writeEndObject();
                    break;
                }
                case INVALID_EMAIL: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "invalid_email");
                    g.writeObjectField("invalid_email", value.invalidEmailValue);
                    g.writeEndObject();
                    break;
                }
                case UNVERIFIED_DROPBOX_ID: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "unverified_dropbox_id");
                    g.writeObjectField("unverified_dropbox_id", value.unverifiedDropboxIdValue);
                    g.writeEndObject();
                    break;
                }
                case GROUP_DELETED: {
                    g.writeString("group_deleted");
                    break;
                }
                case GROUP_NOT_ON_TEAM: {
                    g.writeString("group_not_on_team");
                    break;
                }
                case OTHER: {
                    g.writeString("other");
                }
            }
        }
    }

    public static enum Tag {
        INVALID_DROPBOX_ID,
        INVALID_EMAIL,
        UNVERIFIED_DROPBOX_ID,
        GROUP_DELETED,
        GROUP_NOT_ON_TEAM,
        OTHER;

    }
}

