/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.sharing.PendingUploadMode;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
class CreateSharedLinkArg {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String path;
    protected final boolean shortUrl;
    protected final PendingUploadMode pendingUpload;

    public CreateSharedLinkArg(String path, boolean shortUrl, PendingUploadMode pendingUpload) {
        if (path == null) {
            throw new IllegalArgumentException("Required value for 'path' is null");
        }
        this.path = path;
        this.shortUrl = shortUrl;
        this.pendingUpload = pendingUpload;
    }

    public CreateSharedLinkArg(String path) {
        this(path, false, null);
    }

    public String getPath() {
        return this.path;
    }

    public boolean getShortUrl() {
        return this.shortUrl;
    }

    public PendingUploadMode getPendingUpload() {
        return this.pendingUpload;
    }

    public static Builder newBuilder(String path) {
        return new Builder(path);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.path, this.shortUrl, this.pendingUpload});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            CreateSharedLinkArg other = (CreateSharedLinkArg)obj;
            return (this.path == other.path || this.path.equals(other.path)) && this.shortUrl == other.shortUrl && (this.pendingUpload == other.pendingUpload || this.pendingUpload != null && this.pendingUpload.equals((Object)other.pendingUpload));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<CreateSharedLinkArg> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(CreateSharedLinkArg.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(CreateSharedLinkArg.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<CreateSharedLinkArg> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public CreateSharedLinkArg deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String path = null;
            Boolean shortUrl = null;
            PendingUploadMode pendingUpload = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("path".equals(_field)) {
                    path = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("short_url".equals(_field)) {
                    shortUrl = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("pending_upload".equals(_field)) {
                    pendingUpload = _p.readValueAs(PendingUploadMode.class);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (path == null) {
                throw new JsonParseException(_p, "Required field \"path\" is missing.");
            }
            return new CreateSharedLinkArg(path, shortUrl, pendingUpload);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<CreateSharedLinkArg> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(CreateSharedLinkArg.class);
        }

        public Serializer(boolean unwrapping) {
            super(CreateSharedLinkArg.class, unwrapping);
        }

        @Override
        protected JsonSerializer<CreateSharedLinkArg> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(CreateSharedLinkArg value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("path", value.path);
            g.writeObjectField("short_url", value.shortUrl);
            if (value.pendingUpload != null) {
                g.writeObjectField("pending_upload", (Object)value.pendingUpload);
            }
        }
    }

    public static class Builder {
        protected final String path;
        protected boolean shortUrl;
        protected PendingUploadMode pendingUpload;

        protected Builder(String path) {
            if (path == null) {
                throw new IllegalArgumentException("Required value for 'path' is null");
            }
            this.path = path;
            this.shortUrl = false;
            this.pendingUpload = null;
        }

        public Builder withShortUrl(Boolean shortUrl) {
            this.shortUrl = shortUrl != null ? shortUrl : false;
            return this;
        }

        public Builder withPendingUpload(PendingUploadMode pendingUpload) {
            this.pendingUpload = pendingUpload;
            return this;
        }

        public CreateSharedLinkArg build() {
            return new CreateSharedLinkArg(this.path, this.shortUrl, this.pendingUpload);
        }
    }
}

