/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.dropbox.core.v2.files.LookupError;
import com.dropbox.core.v2.sharing.SharedLinkSettingsError;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class CreateSharedLinkWithSettingsError {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    public static final CreateSharedLinkWithSettingsError EMAIL_NOT_VERIFIED = new CreateSharedLinkWithSettingsError(Tag.EMAIL_NOT_VERIFIED, null, null);
    public static final CreateSharedLinkWithSettingsError SHARED_LINK_ALREADY_EXISTS = new CreateSharedLinkWithSettingsError(Tag.SHARED_LINK_ALREADY_EXISTS, null, null);
    public static final CreateSharedLinkWithSettingsError ACCESS_DENIED = new CreateSharedLinkWithSettingsError(Tag.ACCESS_DENIED, null, null);
    private final Tag tag;
    private final LookupError pathValue;
    private final SharedLinkSettingsError settingsErrorValue;

    private CreateSharedLinkWithSettingsError(Tag tag, LookupError pathValue, SharedLinkSettingsError settingsErrorValue) {
        this.tag = tag;
        this.pathValue = pathValue;
        this.settingsErrorValue = settingsErrorValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isPath() {
        return this.tag == Tag.PATH;
    }

    public static CreateSharedLinkWithSettingsError path(LookupError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new CreateSharedLinkWithSettingsError(Tag.PATH, value, null);
    }

    public LookupError getPathValue() {
        if (this.tag != Tag.PATH) {
            throw new IllegalStateException("Invalid tag: required Tag.PATH, but was Tag." + this.tag.name());
        }
        return this.pathValue;
    }

    public boolean isEmailNotVerified() {
        return this.tag == Tag.EMAIL_NOT_VERIFIED;
    }

    public boolean isSharedLinkAlreadyExists() {
        return this.tag == Tag.SHARED_LINK_ALREADY_EXISTS;
    }

    public boolean isSettingsError() {
        return this.tag == Tag.SETTINGS_ERROR;
    }

    public static CreateSharedLinkWithSettingsError settingsError(SharedLinkSettingsError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new CreateSharedLinkWithSettingsError(Tag.SETTINGS_ERROR, null, value);
    }

    public SharedLinkSettingsError getSettingsErrorValue() {
        if (this.tag != Tag.SETTINGS_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.SETTINGS_ERROR, but was Tag." + this.tag.name());
        }
        return this.settingsErrorValue;
    }

    public boolean isAccessDenied() {
        return this.tag == Tag.ACCESS_DENIED;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.pathValue, this.settingsErrorValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CreateSharedLinkWithSettingsError) {
            CreateSharedLinkWithSettingsError other = (CreateSharedLinkWithSettingsError)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case PATH: {
                    return this.pathValue == other.pathValue || this.pathValue.equals(other.pathValue);
                }
                case EMAIL_NOT_VERIFIED: {
                    return true;
                }
                case SHARED_LINK_ALREADY_EXISTS: {
                    return true;
                }
                case SETTINGS_ERROR: {
                    return this.settingsErrorValue == other.settingsErrorValue || this.settingsErrorValue.equals((Object)other.settingsErrorValue);
                }
                case ACCESS_DENIED: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<CreateSharedLinkWithSettingsError, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(CreateSharedLinkWithSettingsError.class, Deserializer.getTagMapping(), null, new Class[0]);
        }

        @Override
        public CreateSharedLinkWithSettingsError deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case PATH: {
                    LookupError value = null;
                    Deserializer.expectField(_p, "path");
                    value = _p.readValueAs(LookupError.class);
                    _p.nextToken();
                    return CreateSharedLinkWithSettingsError.path(value);
                }
                case EMAIL_NOT_VERIFIED: {
                    return EMAIL_NOT_VERIFIED;
                }
                case SHARED_LINK_ALREADY_EXISTS: {
                    return SHARED_LINK_ALREADY_EXISTS;
                }
                case SETTINGS_ERROR: {
                    SharedLinkSettingsError value = null;
                    Deserializer.expectField(_p, "settings_error");
                    value = _p.readValueAs(SharedLinkSettingsError.class);
                    _p.nextToken();
                    return CreateSharedLinkWithSettingsError.settingsError(value);
                }
                case ACCESS_DENIED: {
                    return ACCESS_DENIED;
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("path", Tag.PATH);
            values.put("email_not_verified", Tag.EMAIL_NOT_VERIFIED);
            values.put("shared_link_already_exists", Tag.SHARED_LINK_ALREADY_EXISTS);
            values.put("settings_error", Tag.SETTINGS_ERROR);
            values.put("access_denied", Tag.ACCESS_DENIED);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<CreateSharedLinkWithSettingsError> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(CreateSharedLinkWithSettingsError.class, new Class[0]);
        }

        @Override
        public void serialize(CreateSharedLinkWithSettingsError value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case PATH: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "path");
                    g.writeObjectField("path", value.pathValue);
                    g.writeEndObject();
                    break;
                }
                case EMAIL_NOT_VERIFIED: {
                    g.writeString("email_not_verified");
                    break;
                }
                case SHARED_LINK_ALREADY_EXISTS: {
                    g.writeString("shared_link_already_exists");
                    break;
                }
                case SETTINGS_ERROR: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "settings_error");
                    g.writeObjectField("settings_error", (Object)value.settingsErrorValue);
                    g.writeEndObject();
                    break;
                }
                case ACCESS_DENIED: {
                    g.writeString("access_denied");
                }
            }
        }
    }

    public static enum Tag {
        PATH,
        EMAIL_NOT_VERIFIED,
        SHARED_LINK_ALREADY_EXISTS,
        SETTINGS_ERROR,
        ACCESS_DENIED;

    }
}

