/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.sharing.CollectionLinkMetadata;
import com.dropbox.core.v2.sharing.PathLinkMetadata;
import com.dropbox.core.v2.sharing.Visibility;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class LinkMetadata {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String url;
    protected final Visibility visibility;
    protected final Date expires;

    public LinkMetadata(String url, Visibility visibility, Date expires) {
        if (url == null) {
            throw new IllegalArgumentException("Required value for 'url' is null");
        }
        this.url = url;
        if (visibility == null) {
            throw new IllegalArgumentException("Required value for 'visibility' is null");
        }
        this.visibility = visibility;
        this.expires = expires;
    }

    public LinkMetadata(String url, Visibility visibility) {
        this(url, visibility, null);
    }

    public String getUrl() {
        return this.url;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public Date getExpires() {
        return this.expires;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.url, this.visibility, this.expires});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            LinkMetadata other = (LinkMetadata)obj;
            return !(this.url != other.url && !this.url.equals(other.url) || this.visibility != other.visibility && !this.visibility.equals((Object)other.visibility) || this.expires != other.expires && (this.expires == null || !this.expires.equals(other.expires)));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<LinkMetadata> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(LinkMetadata.class, PathLinkMetadata.class, CollectionLinkMetadata.class);
        }

        public Deserializer(boolean unwrapping) {
            super(LinkMetadata.class, unwrapping, PathLinkMetadata.class, CollectionLinkMetadata.class);
        }

        @Override
        protected JsonDeserializer<LinkMetadata> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public LinkMetadata deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String _subtype_tag = Deserializer.readEnumeratedSubtypeTag(_p, new String[0]);
            if ("path".equals(_subtype_tag)) {
                return this.readCollapsedStructValue(PathLinkMetadata.class, _p, _ctx);
            }
            if ("collection".equals(_subtype_tag)) {
                return this.readCollapsedStructValue(CollectionLinkMetadata.class, _p, _ctx);
            }
            String url = null;
            Visibility visibility = null;
            Date expires = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("url".equals(_field)) {
                    url = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("visibility".equals(_field)) {
                    visibility = _p.readValueAs(Visibility.class);
                    _p.nextToken();
                    continue;
                }
                if ("expires".equals(_field)) {
                    expires = _ctx.parseDate(Deserializer.getStringValue(_p));
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (url == null) {
                throw new JsonParseException(_p, "Required field \"url\" is missing.");
            }
            if (visibility == null) {
                throw new JsonParseException(_p, "Required field \"visibility\" is missing.");
            }
            return new LinkMetadata(url, visibility, expires);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<LinkMetadata> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(LinkMetadata.class);
        }

        public Serializer(boolean unwrapping) {
            super(LinkMetadata.class, unwrapping);
        }

        @Override
        protected void serializeFields(LinkMetadata value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("url", value.url);
            g.writeObjectField("visibility", (Object)value.visibility);
            if (value.expires != null) {
                g.writeObjectField("expires", value.expires);
            }
        }
    }
}

