/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.sharing.SharedLinkMetadata;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class ListSharedLinksResult {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final List<SharedLinkMetadata> links;
    protected final boolean hasMore;
    protected final String cursor;

    public ListSharedLinksResult(List<SharedLinkMetadata> links, boolean hasMore, String cursor) {
        if (links == null) {
            throw new IllegalArgumentException("Required value for 'links' is null");
        }
        for (SharedLinkMetadata x : links) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'links' is null");
        }
        this.links = links;
        this.hasMore = hasMore;
        this.cursor = cursor;
    }

    public ListSharedLinksResult(List<SharedLinkMetadata> links, boolean hasMore) {
        this(links, hasMore, null);
    }

    public List<SharedLinkMetadata> getLinks() {
        return this.links;
    }

    public boolean getHasMore() {
        return this.hasMore;
    }

    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.links, this.hasMore, this.cursor});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            ListSharedLinksResult other = (ListSharedLinksResult)obj;
            return (this.links == other.links || this.links.equals(other.links)) && this.hasMore == other.hasMore && (this.cursor == other.cursor || this.cursor != null && this.cursor.equals(other.cursor));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<ListSharedLinksResult> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(ListSharedLinksResult.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(ListSharedLinksResult.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<ListSharedLinksResult> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public ListSharedLinksResult deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            ArrayList<SharedLinkMetadata> links = null;
            Boolean hasMore = null;
            String cursor = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("links".equals(_field)) {
                    Deserializer.expectArrayStart(_p);
                    links = new ArrayList<SharedLinkMetadata>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        SharedLinkMetadata _x = null;
                        _x = _p.readValueAs(SharedLinkMetadata.class);
                        _p.nextToken();
                        links.add(_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    continue;
                }
                if ("has_more".equals(_field)) {
                    hasMore = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("cursor".equals(_field)) {
                    cursor = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (links == null) {
                throw new JsonParseException(_p, "Required field \"links\" is missing.");
            }
            if (hasMore == null) {
                throw new JsonParseException(_p, "Required field \"has_more\" is missing.");
            }
            return new ListSharedLinksResult(links, hasMore, cursor);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<ListSharedLinksResult> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(ListSharedLinksResult.class);
        }

        public Serializer(boolean unwrapping) {
            super(ListSharedLinksResult.class, unwrapping);
        }

        @Override
        protected JsonSerializer<ListSharedLinksResult> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(ListSharedLinksResult value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("links", value.links);
            g.writeObjectField("has_more", value.hasMore);
            if (value.cursor != null) {
                g.writeObjectField("cursor", value.cursor);
            }
        }
    }
}

