/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.sharing.AccessLevel;
import com.dropbox.core.v2.sharing.MemberPermission;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class MembershipInfo {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final AccessLevel accessType;
    protected final List<MemberPermission> permissions;
    protected final String initials;
    protected final boolean isInherited;

    public MembershipInfo(AccessLevel accessType, List<MemberPermission> permissions, String initials, boolean isInherited) {
        if (accessType == null) {
            throw new IllegalArgumentException("Required value for 'accessType' is null");
        }
        this.accessType = accessType;
        if (permissions != null) {
            for (MemberPermission x : permissions) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'permissions' is null");
            }
        }
        this.permissions = permissions;
        this.initials = initials;
        this.isInherited = isInherited;
    }

    public MembershipInfo(AccessLevel accessType) {
        this(accessType, null, null, false);
    }

    public AccessLevel getAccessType() {
        return this.accessType;
    }

    public List<MemberPermission> getPermissions() {
        return this.permissions;
    }

    public String getInitials() {
        return this.initials;
    }

    public boolean getIsInherited() {
        return this.isInherited;
    }

    public static Builder newBuilder(AccessLevel accessType) {
        return new Builder(accessType);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.accessType, this.permissions, this.initials, this.isInherited});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            MembershipInfo other = (MembershipInfo)obj;
            return (this.accessType == other.accessType || this.accessType.equals((Object)other.accessType)) && (this.permissions == other.permissions || this.permissions != null && this.permissions.equals(other.permissions)) && (this.initials == other.initials || this.initials != null && this.initials.equals(other.initials)) && this.isInherited == other.isInherited;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<MembershipInfo> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(MembershipInfo.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(MembershipInfo.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<MembershipInfo> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public MembershipInfo deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            AccessLevel accessType = null;
            ArrayList<MemberPermission> permissions = null;
            String initials = null;
            Boolean isInherited = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("access_type".equals(_field)) {
                    accessType = _p.readValueAs(AccessLevel.class);
                    _p.nextToken();
                    continue;
                }
                if ("permissions".equals(_field)) {
                    Deserializer.expectArrayStart(_p);
                    permissions = new ArrayList<MemberPermission>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        MemberPermission _x = null;
                        _x = _p.readValueAs(MemberPermission.class);
                        _p.nextToken();
                        permissions.add(_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    continue;
                }
                if ("initials".equals(_field)) {
                    initials = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("is_inherited".equals(_field)) {
                    isInherited = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (accessType == null) {
                throw new JsonParseException(_p, "Required field \"access_type\" is missing.");
            }
            return new MembershipInfo(accessType, permissions, initials, isInherited);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<MembershipInfo> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(MembershipInfo.class);
        }

        public Serializer(boolean unwrapping) {
            super(MembershipInfo.class, unwrapping);
        }

        @Override
        protected JsonSerializer<MembershipInfo> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(MembershipInfo value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("access_type", (Object)value.accessType);
            if (value.permissions != null) {
                g.writeObjectField("permissions", value.permissions);
            }
            if (value.initials != null) {
                g.writeObjectField("initials", value.initials);
            }
            g.writeObjectField("is_inherited", value.isInherited);
        }
    }

    public static class Builder {
        protected final AccessLevel accessType;
        protected List<MemberPermission> permissions;
        protected String initials;
        protected boolean isInherited;

        protected Builder(AccessLevel accessType) {
            if (accessType == null) {
                throw new IllegalArgumentException("Required value for 'accessType' is null");
            }
            this.accessType = accessType;
            this.permissions = null;
            this.initials = null;
            this.isInherited = false;
        }

        public Builder withPermissions(List<MemberPermission> permissions) {
            if (permissions != null) {
                for (MemberPermission x : permissions) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'permissions' is null");
                }
            }
            this.permissions = permissions;
            return this;
        }

        public Builder withInitials(String initials) {
            this.initials = initials;
            return this;
        }

        public Builder withIsInherited(Boolean isInherited) {
            this.isInherited = isInherited != null ? isInherited : false;
            return this;
        }

        public MembershipInfo build() {
            return new MembershipInfo(this.accessType, this.permissions, this.initials, this.isInherited);
        }
    }
}

