/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.dropbox.core.v2.sharing.SharedLinkSettingsError;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class ModifySharedLinkSettingsError {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    public static final ModifySharedLinkSettingsError SHARED_LINK_NOT_FOUND = new ModifySharedLinkSettingsError(Tag.SHARED_LINK_NOT_FOUND, null);
    public static final ModifySharedLinkSettingsError SHARED_LINK_ACCESS_DENIED = new ModifySharedLinkSettingsError(Tag.SHARED_LINK_ACCESS_DENIED, null);
    public static final ModifySharedLinkSettingsError OTHER = new ModifySharedLinkSettingsError(Tag.OTHER, null);
    public static final ModifySharedLinkSettingsError EMAIL_NOT_VERIFIED = new ModifySharedLinkSettingsError(Tag.EMAIL_NOT_VERIFIED, null);
    private final Tag tag;
    private final SharedLinkSettingsError settingsErrorValue;

    private ModifySharedLinkSettingsError(Tag tag, SharedLinkSettingsError settingsErrorValue) {
        this.tag = tag;
        this.settingsErrorValue = settingsErrorValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isSharedLinkNotFound() {
        return this.tag == Tag.SHARED_LINK_NOT_FOUND;
    }

    public boolean isSharedLinkAccessDenied() {
        return this.tag == Tag.SHARED_LINK_ACCESS_DENIED;
    }

    public boolean isOther() {
        return this.tag == Tag.OTHER;
    }

    public boolean isSettingsError() {
        return this.tag == Tag.SETTINGS_ERROR;
    }

    public static ModifySharedLinkSettingsError settingsError(SharedLinkSettingsError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new ModifySharedLinkSettingsError(Tag.SETTINGS_ERROR, value);
    }

    public SharedLinkSettingsError getSettingsErrorValue() {
        if (this.tag != Tag.SETTINGS_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.SETTINGS_ERROR, but was Tag." + this.tag.name());
        }
        return this.settingsErrorValue;
    }

    public boolean isEmailNotVerified() {
        return this.tag == Tag.EMAIL_NOT_VERIFIED;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.settingsErrorValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ModifySharedLinkSettingsError) {
            ModifySharedLinkSettingsError other = (ModifySharedLinkSettingsError)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case SHARED_LINK_NOT_FOUND: {
                    return true;
                }
                case SHARED_LINK_ACCESS_DENIED: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
                case SETTINGS_ERROR: {
                    return this.settingsErrorValue == other.settingsErrorValue || this.settingsErrorValue.equals((Object)other.settingsErrorValue);
                }
                case EMAIL_NOT_VERIFIED: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<ModifySharedLinkSettingsError, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(ModifySharedLinkSettingsError.class, Deserializer.getTagMapping(), null, new Class[0]);
        }

        @Override
        public ModifySharedLinkSettingsError deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case SHARED_LINK_NOT_FOUND: {
                    return SHARED_LINK_NOT_FOUND;
                }
                case SHARED_LINK_ACCESS_DENIED: {
                    return SHARED_LINK_ACCESS_DENIED;
                }
                case OTHER: {
                    return OTHER;
                }
                case SETTINGS_ERROR: {
                    SharedLinkSettingsError value = null;
                    Deserializer.expectField(_p, "settings_error");
                    value = _p.readValueAs(SharedLinkSettingsError.class);
                    _p.nextToken();
                    return ModifySharedLinkSettingsError.settingsError(value);
                }
                case EMAIL_NOT_VERIFIED: {
                    return EMAIL_NOT_VERIFIED;
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("settings_error", Tag.SETTINGS_ERROR);
            values.put("email_not_verified", Tag.EMAIL_NOT_VERIFIED);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<ModifySharedLinkSettingsError> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(ModifySharedLinkSettingsError.class, new Class[0]);
        }

        @Override
        public void serialize(ModifySharedLinkSettingsError value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case SHARED_LINK_NOT_FOUND: {
                    g.writeString("shared_link_not_found");
                    break;
                }
                case SHARED_LINK_ACCESS_DENIED: {
                    g.writeString("shared_link_access_denied");
                    break;
                }
                case OTHER: {
                    g.writeString("other");
                    break;
                }
                case SETTINGS_ERROR: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "settings_error");
                    g.writeObjectField("settings_error", (Object)value.settingsErrorValue);
                    g.writeEndObject();
                    break;
                }
                case EMAIL_NOT_VERIFIED: {
                    g.writeString("email_not_verified");
                }
            }
        }
    }

    public static enum Tag {
        SHARED_LINK_NOT_FOUND,
        SHARED_LINK_ACCESS_DENIED,
        OTHER,
        SETTINGS_ERROR,
        EMAIL_NOT_VERIFIED;

    }
}

