/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.team.DesktopPlatform;
import com.dropbox.core.v2.team.DeviceSession;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class DesktopClientSession
extends DeviceSession {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String hostName;
    protected final DesktopPlatform clientType;
    protected final String clientVersion;
    protected final String platform;
    protected final boolean isDeleteOnUnlinkSupported;

    public DesktopClientSession(String sessionId, String hostName, DesktopPlatform clientType, String clientVersion, String platform, boolean isDeleteOnUnlinkSupported, String ipAddress, String country, Date created, Date updated) {
        super(sessionId, ipAddress, country, created, updated);
        if (hostName == null) {
            throw new IllegalArgumentException("Required value for 'hostName' is null");
        }
        this.hostName = hostName;
        if (clientType == null) {
            throw new IllegalArgumentException("Required value for 'clientType' is null");
        }
        this.clientType = clientType;
        if (clientVersion == null) {
            throw new IllegalArgumentException("Required value for 'clientVersion' is null");
        }
        this.clientVersion = clientVersion;
        if (platform == null) {
            throw new IllegalArgumentException("Required value for 'platform' is null");
        }
        this.platform = platform;
        this.isDeleteOnUnlinkSupported = isDeleteOnUnlinkSupported;
    }

    public DesktopClientSession(String sessionId, String hostName, DesktopPlatform clientType, String clientVersion, String platform, boolean isDeleteOnUnlinkSupported) {
        this(sessionId, hostName, clientType, clientVersion, platform, isDeleteOnUnlinkSupported, null, null, null, null);
    }

    public String getHostName() {
        return this.hostName;
    }

    public DesktopPlatform getClientType() {
        return this.clientType;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public String getPlatform() {
        return this.platform;
    }

    public boolean getIsDeleteOnUnlinkSupported() {
        return this.isDeleteOnUnlinkSupported;
    }

    public static Builder newBuilder(String sessionId, String hostName, DesktopPlatform clientType, String clientVersion, String platform, boolean isDeleteOnUnlinkSupported) {
        return new Builder(sessionId, hostName, clientType, clientVersion, platform, isDeleteOnUnlinkSupported);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.hostName, this.clientType, this.clientVersion, this.platform, this.isDeleteOnUnlinkSupported});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            DesktopClientSession other = (DesktopClientSession)obj;
            return !(this.sessionId != other.sessionId && !this.sessionId.equals(other.sessionId) || this.hostName != other.hostName && !this.hostName.equals(other.hostName) || this.clientType != other.clientType && !this.clientType.equals((Object)other.clientType) || this.clientVersion != other.clientVersion && !this.clientVersion.equals(other.clientVersion) || this.platform != other.platform && !this.platform.equals(other.platform) || this.isDeleteOnUnlinkSupported != other.isDeleteOnUnlinkSupported || this.ipAddress != other.ipAddress && (this.ipAddress == null || !this.ipAddress.equals(other.ipAddress)) || this.country != other.country && (this.country == null || !this.country.equals(other.country)) || this.created != other.created && (this.created == null || !this.created.equals(other.created)) || this.updated != other.updated && (this.updated == null || !this.updated.equals(other.updated)));
        }
        return false;
    }

    @Override
    public String toString() {
        return this.serialize(false);
    }

    @Override
    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<DesktopClientSession> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(DesktopClientSession.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(DesktopClientSession.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<DesktopClientSession> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public DesktopClientSession deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String sessionId = null;
            String hostName = null;
            DesktopPlatform clientType = null;
            String clientVersion = null;
            String platform = null;
            Boolean isDeleteOnUnlinkSupported = null;
            String ipAddress = null;
            String country = null;
            Date created = null;
            Date updated = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("session_id".equals(_field)) {
                    sessionId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("host_name".equals(_field)) {
                    hostName = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("client_type".equals(_field)) {
                    clientType = _p.readValueAs(DesktopPlatform.class);
                    _p.nextToken();
                    continue;
                }
                if ("client_version".equals(_field)) {
                    clientVersion = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("platform".equals(_field)) {
                    platform = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("is_delete_on_unlink_supported".equals(_field)) {
                    isDeleteOnUnlinkSupported = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("ip_address".equals(_field)) {
                    ipAddress = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("country".equals(_field)) {
                    country = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("created".equals(_field)) {
                    created = _ctx.parseDate(Deserializer.getStringValue(_p));
                    _p.nextToken();
                    continue;
                }
                if ("updated".equals(_field)) {
                    updated = _ctx.parseDate(Deserializer.getStringValue(_p));
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (sessionId == null) {
                throw new JsonParseException(_p, "Required field \"session_id\" is missing.");
            }
            if (hostName == null) {
                throw new JsonParseException(_p, "Required field \"host_name\" is missing.");
            }
            if (clientType == null) {
                throw new JsonParseException(_p, "Required field \"client_type\" is missing.");
            }
            if (clientVersion == null) {
                throw new JsonParseException(_p, "Required field \"client_version\" is missing.");
            }
            if (platform == null) {
                throw new JsonParseException(_p, "Required field \"platform\" is missing.");
            }
            if (isDeleteOnUnlinkSupported == null) {
                throw new JsonParseException(_p, "Required field \"is_delete_on_unlink_supported\" is missing.");
            }
            return new DesktopClientSession(sessionId, hostName, clientType, clientVersion, platform, isDeleteOnUnlinkSupported, ipAddress, country, created, updated);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<DesktopClientSession> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(DesktopClientSession.class);
        }

        public Serializer(boolean unwrapping) {
            super(DesktopClientSession.class, unwrapping);
        }

        @Override
        protected JsonSerializer<DesktopClientSession> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(DesktopClientSession value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("session_id", value.sessionId);
            g.writeObjectField("host_name", value.hostName);
            g.writeObjectField("client_type", (Object)value.clientType);
            g.writeObjectField("client_version", value.clientVersion);
            g.writeObjectField("platform", value.platform);
            g.writeObjectField("is_delete_on_unlink_supported", value.isDeleteOnUnlinkSupported);
            if (value.ipAddress != null) {
                g.writeObjectField("ip_address", value.ipAddress);
            }
            if (value.country != null) {
                g.writeObjectField("country", value.country);
            }
            if (value.created != null) {
                g.writeObjectField("created", value.created);
            }
            if (value.updated != null) {
                g.writeObjectField("updated", value.updated);
            }
        }
    }

    public static class Builder
    extends DeviceSession.Builder {
        protected final String hostName;
        protected final DesktopPlatform clientType;
        protected final String clientVersion;
        protected final String platform;
        protected final boolean isDeleteOnUnlinkSupported;

        protected Builder(String sessionId, String hostName, DesktopPlatform clientType, String clientVersion, String platform, boolean isDeleteOnUnlinkSupported) {
            super(sessionId);
            if (hostName == null) {
                throw new IllegalArgumentException("Required value for 'hostName' is null");
            }
            this.hostName = hostName;
            if (clientType == null) {
                throw new IllegalArgumentException("Required value for 'clientType' is null");
            }
            this.clientType = clientType;
            if (clientVersion == null) {
                throw new IllegalArgumentException("Required value for 'clientVersion' is null");
            }
            this.clientVersion = clientVersion;
            if (platform == null) {
                throw new IllegalArgumentException("Required value for 'platform' is null");
            }
            this.platform = platform;
            this.isDeleteOnUnlinkSupported = isDeleteOnUnlinkSupported;
        }

        @Override
        public DesktopClientSession build() {
            return new DesktopClientSession(this.sessionId, this.hostName, this.clientType, this.clientVersion, this.platform, this.isDeleteOnUnlinkSupported, this.ipAddress, this.country, this.created, this.updated);
        }
    }
}

