/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class DeviceSession {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String sessionId;
    protected final String ipAddress;
    protected final String country;
    protected final Date created;
    protected final Date updated;

    public DeviceSession(String sessionId, String ipAddress, String country, Date created, Date updated) {
        if (sessionId == null) {
            throw new IllegalArgumentException("Required value for 'sessionId' is null");
        }
        this.sessionId = sessionId;
        this.ipAddress = ipAddress;
        this.country = country;
        this.created = created;
        this.updated = updated;
    }

    public DeviceSession(String sessionId) {
        this(sessionId, null, null, null, null);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getCountry() {
        return this.country;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public static Builder newBuilder(String sessionId) {
        return new Builder(sessionId);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.sessionId, this.ipAddress, this.country, this.created, this.updated});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            DeviceSession other = (DeviceSession)obj;
            return (this.sessionId == other.sessionId || this.sessionId.equals(other.sessionId)) && (this.ipAddress == other.ipAddress || this.ipAddress != null && this.ipAddress.equals(other.ipAddress)) && (this.country == other.country || this.country != null && this.country.equals(other.country)) && (this.created == other.created || this.created != null && this.created.equals(other.created)) && (this.updated == other.updated || this.updated != null && this.updated.equals(other.updated));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<DeviceSession> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(DeviceSession.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(DeviceSession.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<DeviceSession> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public DeviceSession deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String sessionId = null;
            String ipAddress = null;
            String country = null;
            Date created = null;
            Date updated = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("session_id".equals(_field)) {
                    sessionId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("ip_address".equals(_field)) {
                    ipAddress = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("country".equals(_field)) {
                    country = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("created".equals(_field)) {
                    created = _ctx.parseDate(Deserializer.getStringValue(_p));
                    _p.nextToken();
                    continue;
                }
                if ("updated".equals(_field)) {
                    updated = _ctx.parseDate(Deserializer.getStringValue(_p));
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (sessionId == null) {
                throw new JsonParseException(_p, "Required field \"session_id\" is missing.");
            }
            return new DeviceSession(sessionId, ipAddress, country, created, updated);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<DeviceSession> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(DeviceSession.class);
        }

        public Serializer(boolean unwrapping) {
            super(DeviceSession.class, unwrapping);
        }

        @Override
        protected JsonSerializer<DeviceSession> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(DeviceSession value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("session_id", value.sessionId);
            if (value.ipAddress != null) {
                g.writeObjectField("ip_address", value.ipAddress);
            }
            if (value.country != null) {
                g.writeObjectField("country", value.country);
            }
            if (value.created != null) {
                g.writeObjectField("created", value.created);
            }
            if (value.updated != null) {
                g.writeObjectField("updated", value.updated);
            }
        }
    }

    public static class Builder {
        protected final String sessionId;
        protected String ipAddress;
        protected String country;
        protected Date created;
        protected Date updated;

        protected Builder(String sessionId) {
            if (sessionId == null) {
                throw new IllegalArgumentException("Required value for 'sessionId' is null");
            }
            this.sessionId = sessionId;
            this.ipAddress = null;
            this.country = null;
            this.created = null;
            this.updated = null;
        }

        public Builder withIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder withCountry(String country) {
            this.country = country;
            return this;
        }

        public Builder withCreated(Date created) {
            this.created = created;
            return this;
        }

        public Builder withUpdated(Date updated) {
            this.updated = updated;
            return this;
        }

        public DeviceSession build() {
            return new DeviceSession(this.sessionId, this.ipAddress, this.country, this.created, this.updated);
        }
    }
}

