/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class GroupSummary {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String groupName;
    protected final String groupId;
    protected final String groupExternalId;
    protected final long memberCount;

    public GroupSummary(String groupName, String groupId, long memberCount, String groupExternalId) {
        if (groupName == null) {
            throw new IllegalArgumentException("Required value for 'groupName' is null");
        }
        this.groupName = groupName;
        if (groupId == null) {
            throw new IllegalArgumentException("Required value for 'groupId' is null");
        }
        this.groupId = groupId;
        this.groupExternalId = groupExternalId;
        this.memberCount = memberCount;
    }

    public GroupSummary(String groupName, String groupId, long memberCount) {
        this(groupName, groupId, memberCount, null);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getGroupExternalId() {
        return this.groupExternalId;
    }

    public long getMemberCount() {
        return this.memberCount;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.groupName, this.groupId, this.groupExternalId, this.memberCount});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            GroupSummary other = (GroupSummary)obj;
            return !(this.groupName != other.groupName && !this.groupName.equals(other.groupName) || this.groupId != other.groupId && !this.groupId.equals(other.groupId) || this.memberCount != other.memberCount || this.groupExternalId != other.groupExternalId && (this.groupExternalId == null || !this.groupExternalId.equals(other.groupExternalId)));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<GroupSummary> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(GroupSummary.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(GroupSummary.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<GroupSummary> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public GroupSummary deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String groupName = null;
            String groupId = null;
            Long memberCount = null;
            String groupExternalId = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("group_name".equals(_field)) {
                    groupName = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("group_id".equals(_field)) {
                    groupId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("member_count".equals(_field)) {
                    memberCount = _p.getLongValue();
                    Deserializer.assertUnsigned(_p, memberCount);
                    if (memberCount > Integer.MAX_VALUE) {
                        throw new JsonParseException(_p, "expecting a 32-bit unsigned integer, got: " + memberCount);
                    }
                    _p.nextToken();
                    continue;
                }
                if ("group_external_id".equals(_field)) {
                    groupExternalId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (groupName == null) {
                throw new JsonParseException(_p, "Required field \"group_name\" is missing.");
            }
            if (groupId == null) {
                throw new JsonParseException(_p, "Required field \"group_id\" is missing.");
            }
            if (memberCount == null) {
                throw new JsonParseException(_p, "Required field \"member_count\" is missing.");
            }
            return new GroupSummary(groupName, groupId, memberCount, groupExternalId);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<GroupSummary> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(GroupSummary.class);
        }

        public Serializer(boolean unwrapping) {
            super(GroupSummary.class, unwrapping);
        }

        @Override
        protected JsonSerializer<GroupSummary> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(GroupSummary value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("group_name", value.groupName);
            g.writeObjectField("group_id", value.groupId);
            g.writeObjectField("member_count", value.memberCount);
            if (value.groupExternalId != null) {
                g.writeObjectField("group_external_id", value.groupExternalId);
            }
        }
    }
}

