/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.team.GroupSummary;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class GroupsListResult {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final List<GroupSummary> groups;
    protected final String cursor;
    protected final boolean hasMore;

    public GroupsListResult(List<GroupSummary> groups, String cursor, boolean hasMore) {
        if (groups == null) {
            throw new IllegalArgumentException("Required value for 'groups' is null");
        }
        for (GroupSummary x : groups) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'groups' is null");
        }
        this.groups = groups;
        if (cursor == null) {
            throw new IllegalArgumentException("Required value for 'cursor' is null");
        }
        this.cursor = cursor;
        this.hasMore = hasMore;
    }

    public List<GroupSummary> getGroups() {
        return this.groups;
    }

    public String getCursor() {
        return this.cursor;
    }

    public boolean getHasMore() {
        return this.hasMore;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.groups, this.cursor, this.hasMore});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            GroupsListResult other = (GroupsListResult)obj;
            return !(this.groups != other.groups && !this.groups.equals(other.groups) || this.cursor != other.cursor && !this.cursor.equals(other.cursor) || this.hasMore != other.hasMore);
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<GroupsListResult> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(GroupsListResult.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(GroupsListResult.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<GroupsListResult> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public GroupsListResult deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            ArrayList<GroupSummary> groups = null;
            String cursor = null;
            Boolean hasMore = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("groups".equals(_field)) {
                    Deserializer.expectArrayStart(_p);
                    groups = new ArrayList<GroupSummary>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        GroupSummary _x = null;
                        _x = _p.readValueAs(GroupSummary.class);
                        _p.nextToken();
                        groups.add(_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    continue;
                }
                if ("cursor".equals(_field)) {
                    cursor = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("has_more".equals(_field)) {
                    hasMore = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (groups == null) {
                throw new JsonParseException(_p, "Required field \"groups\" is missing.");
            }
            if (cursor == null) {
                throw new JsonParseException(_p, "Required field \"cursor\" is missing.");
            }
            if (hasMore == null) {
                throw new JsonParseException(_p, "Required field \"has_more\" is missing.");
            }
            return new GroupsListResult(groups, cursor, hasMore);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<GroupsListResult> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(GroupsListResult.class);
        }

        public Serializer(boolean unwrapping) {
            super(GroupsListResult.class, unwrapping);
        }

        @Override
        protected JsonSerializer<GroupsListResult> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(GroupsListResult value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("groups", value.groups);
            g.writeObjectField("cursor", value.cursor);
            g.writeObjectField("has_more", value.hasMore);
        }
    }
}

