/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.team.TeamMemberStatus;
import com.dropbox.core.v2.users.Name;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class MemberProfile {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String teamMemberId;
    protected final String externalId;
    protected final String email;
    protected final boolean emailVerified;
    protected final TeamMemberStatus status;
    protected final Name name;

    public MemberProfile(String teamMemberId, String email, boolean emailVerified, TeamMemberStatus status, Name name, String externalId) {
        if (teamMemberId == null) {
            throw new IllegalArgumentException("Required value for 'teamMemberId' is null");
        }
        this.teamMemberId = teamMemberId;
        this.externalId = externalId;
        if (email == null) {
            throw new IllegalArgumentException("Required value for 'email' is null");
        }
        this.email = email;
        this.emailVerified = emailVerified;
        if (status == null) {
            throw new IllegalArgumentException("Required value for 'status' is null");
        }
        this.status = status;
        if (name == null) {
            throw new IllegalArgumentException("Required value for 'name' is null");
        }
        this.name = name;
    }

    public MemberProfile(String teamMemberId, String email, boolean emailVerified, TeamMemberStatus status, Name name) {
        this(teamMemberId, email, emailVerified, status, name, null);
    }

    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean getEmailVerified() {
        return this.emailVerified;
    }

    public TeamMemberStatus getStatus() {
        return this.status;
    }

    public Name getName() {
        return this.name;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.teamMemberId, this.externalId, this.email, this.emailVerified, this.status, this.name});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            MemberProfile other = (MemberProfile)obj;
            return !(this.teamMemberId != other.teamMemberId && !this.teamMemberId.equals(other.teamMemberId) || this.email != other.email && !this.email.equals(other.email) || this.emailVerified != other.emailVerified || this.status != other.status && !this.status.equals((Object)other.status) || this.name != other.name && !this.name.equals(other.name) || this.externalId != other.externalId && (this.externalId == null || !this.externalId.equals(other.externalId)));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<MemberProfile> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(MemberProfile.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(MemberProfile.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<MemberProfile> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public MemberProfile deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String teamMemberId = null;
            String email = null;
            Boolean emailVerified = null;
            TeamMemberStatus status = null;
            Name name = null;
            String externalId = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("team_member_id".equals(_field)) {
                    teamMemberId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("email".equals(_field)) {
                    email = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("email_verified".equals(_field)) {
                    emailVerified = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("status".equals(_field)) {
                    status = _p.readValueAs(TeamMemberStatus.class);
                    _p.nextToken();
                    continue;
                }
                if ("name".equals(_field)) {
                    name = _p.readValueAs(Name.class);
                    _p.nextToken();
                    continue;
                }
                if ("external_id".equals(_field)) {
                    externalId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (teamMemberId == null) {
                throw new JsonParseException(_p, "Required field \"team_member_id\" is missing.");
            }
            if (email == null) {
                throw new JsonParseException(_p, "Required field \"email\" is missing.");
            }
            if (emailVerified == null) {
                throw new JsonParseException(_p, "Required field \"email_verified\" is missing.");
            }
            if (status == null) {
                throw new JsonParseException(_p, "Required field \"status\" is missing.");
            }
            if (name == null) {
                throw new JsonParseException(_p, "Required field \"name\" is missing.");
            }
            return new MemberProfile(teamMemberId, email, emailVerified, status, name, externalId);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<MemberProfile> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(MemberProfile.class);
        }

        public Serializer(boolean unwrapping) {
            super(MemberProfile.class, unwrapping);
        }

        @Override
        protected JsonSerializer<MemberProfile> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(MemberProfile value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("team_member_id", value.teamMemberId);
            g.writeObjectField("email", value.email);
            g.writeObjectField("email_verified", value.emailVerified);
            g.writeObjectField("status", (Object)value.status);
            g.writeObjectField("name", value.name);
            if (value.externalId != null) {
                g.writeObjectField("external_id", value.externalId);
            }
        }
    }
}

