/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.team.TeamMemberInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class MembersListResult {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final List<TeamMemberInfo> members;
    protected final String cursor;
    protected final boolean hasMore;

    public MembersListResult(List<TeamMemberInfo> members, String cursor, boolean hasMore) {
        if (members == null) {
            throw new IllegalArgumentException("Required value for 'members' is null");
        }
        for (TeamMemberInfo x : members) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'members' is null");
        }
        this.members = members;
        if (cursor == null) {
            throw new IllegalArgumentException("Required value for 'cursor' is null");
        }
        this.cursor = cursor;
        this.hasMore = hasMore;
    }

    public List<TeamMemberInfo> getMembers() {
        return this.members;
    }

    public String getCursor() {
        return this.cursor;
    }

    public boolean getHasMore() {
        return this.hasMore;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.members, this.cursor, this.hasMore});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            MembersListResult other = (MembersListResult)obj;
            return !(this.members != other.members && !this.members.equals(other.members) || this.cursor != other.cursor && !this.cursor.equals(other.cursor) || this.hasMore != other.hasMore);
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<MembersListResult> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(MembersListResult.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(MembersListResult.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<MembersListResult> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public MembersListResult deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            ArrayList<TeamMemberInfo> members = null;
            String cursor = null;
            Boolean hasMore = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("members".equals(_field)) {
                    Deserializer.expectArrayStart(_p);
                    members = new ArrayList<TeamMemberInfo>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        TeamMemberInfo _x = null;
                        _x = _p.readValueAs(TeamMemberInfo.class);
                        _p.nextToken();
                        members.add(_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    continue;
                }
                if ("cursor".equals(_field)) {
                    cursor = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("has_more".equals(_field)) {
                    hasMore = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (members == null) {
                throw new JsonParseException(_p, "Required field \"members\" is missing.");
            }
            if (cursor == null) {
                throw new JsonParseException(_p, "Required field \"cursor\" is missing.");
            }
            if (hasMore == null) {
                throw new JsonParseException(_p, "Required field \"has_more\" is missing.");
            }
            return new MembersListResult(members, cursor, hasMore);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<MembersListResult> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(MembersListResult.class);
        }

        public Serializer(boolean unwrapping) {
            super(MembersListResult.class, unwrapping);
        }

        @Override
        protected JsonSerializer<MembersListResult> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(MembersListResult value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("members", value.members);
            g.writeObjectField("cursor", value.cursor);
            g.writeObjectField("has_more", value.hasMore);
        }
    }
}

