/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.team.TeamPolicies;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class TeamGetInfoResult {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String name;
    protected final String teamId;
    protected final long numLicensedUsers;
    protected final long numProvisionedUsers;
    protected final TeamPolicies policies;

    public TeamGetInfoResult(String name, String teamId, long numLicensedUsers, long numProvisionedUsers, TeamPolicies policies) {
        if (name == null) {
            throw new IllegalArgumentException("Required value for 'name' is null");
        }
        this.name = name;
        if (teamId == null) {
            throw new IllegalArgumentException("Required value for 'teamId' is null");
        }
        this.teamId = teamId;
        this.numLicensedUsers = numLicensedUsers;
        this.numProvisionedUsers = numProvisionedUsers;
        if (policies == null) {
            throw new IllegalArgumentException("Required value for 'policies' is null");
        }
        this.policies = policies;
    }

    public String getName() {
        return this.name;
    }

    public String getTeamId() {
        return this.teamId;
    }

    public long getNumLicensedUsers() {
        return this.numLicensedUsers;
    }

    public long getNumProvisionedUsers() {
        return this.numProvisionedUsers;
    }

    public TeamPolicies getPolicies() {
        return this.policies;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.name, this.teamId, this.numLicensedUsers, this.numProvisionedUsers, this.policies});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            TeamGetInfoResult other = (TeamGetInfoResult)obj;
            return !(this.name != other.name && !this.name.equals(other.name) || this.teamId != other.teamId && !this.teamId.equals(other.teamId) || this.numLicensedUsers != other.numLicensedUsers || this.numProvisionedUsers != other.numProvisionedUsers || this.policies != other.policies && !this.policies.equals(other.policies));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<TeamGetInfoResult> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(TeamGetInfoResult.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(TeamGetInfoResult.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<TeamGetInfoResult> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public TeamGetInfoResult deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String name = null;
            String teamId = null;
            Long numLicensedUsers = null;
            Long numProvisionedUsers = null;
            TeamPolicies policies = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("name".equals(_field)) {
                    name = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("team_id".equals(_field)) {
                    teamId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("num_licensed_users".equals(_field)) {
                    numLicensedUsers = _p.getLongValue();
                    Deserializer.assertUnsigned(_p, numLicensedUsers);
                    if (numLicensedUsers > Integer.MAX_VALUE) {
                        throw new JsonParseException(_p, "expecting a 32-bit unsigned integer, got: " + numLicensedUsers);
                    }
                    _p.nextToken();
                    continue;
                }
                if ("num_provisioned_users".equals(_field)) {
                    numProvisionedUsers = _p.getLongValue();
                    Deserializer.assertUnsigned(_p, numProvisionedUsers);
                    if (numProvisionedUsers > Integer.MAX_VALUE) {
                        throw new JsonParseException(_p, "expecting a 32-bit unsigned integer, got: " + numProvisionedUsers);
                    }
                    _p.nextToken();
                    continue;
                }
                if ("policies".equals(_field)) {
                    policies = _p.readValueAs(TeamPolicies.class);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (name == null) {
                throw new JsonParseException(_p, "Required field \"name\" is missing.");
            }
            if (teamId == null) {
                throw new JsonParseException(_p, "Required field \"team_id\" is missing.");
            }
            if (numLicensedUsers == null) {
                throw new JsonParseException(_p, "Required field \"num_licensed_users\" is missing.");
            }
            if (numProvisionedUsers == null) {
                throw new JsonParseException(_p, "Required field \"num_provisioned_users\" is missing.");
            }
            if (policies == null) {
                throw new JsonParseException(_p, "Required field \"policies\" is missing.");
            }
            return new TeamGetInfoResult(name, teamId, numLicensedUsers, numProvisionedUsers, policies);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<TeamGetInfoResult> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(TeamGetInfoResult.class);
        }

        public Serializer(boolean unwrapping) {
            super(TeamGetInfoResult.class, unwrapping);
        }

        @Override
        protected JsonSerializer<TeamGetInfoResult> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(TeamGetInfoResult value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("name", value.name);
            g.writeObjectField("team_id", value.teamId);
            g.writeObjectField("num_licensed_users", value.numLicensedUsers);
            g.writeObjectField("num_provisioned_users", value.numProvisionedUsers);
            g.writeObjectField("policies", value.policies);
        }
    }
}

