/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.team.MemberProfile;
import com.dropbox.core.v2.team.TeamMemberStatus;
import com.dropbox.core.v2.users.Name;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class TeamMemberProfile
extends MemberProfile {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final List<String> groups;

    public TeamMemberProfile(String teamMemberId, String email, boolean emailVerified, TeamMemberStatus status, Name name, List<String> groups, String externalId) {
        super(teamMemberId, email, emailVerified, status, name, externalId);
        if (groups == null) {
            throw new IllegalArgumentException("Required value for 'groups' is null");
        }
        for (String x : groups) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'groups' is null");
        }
        this.groups = groups;
    }

    public TeamMemberProfile(String teamMemberId, String email, boolean emailVerified, TeamMemberStatus status, Name name, List<String> groups) {
        this(teamMemberId, email, emailVerified, status, name, groups, null);
    }

    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.groups});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            TeamMemberProfile other = (TeamMemberProfile)obj;
            return !(this.teamMemberId != other.teamMemberId && !this.teamMemberId.equals(other.teamMemberId) || this.email != other.email && !this.email.equals(other.email) || this.emailVerified != other.emailVerified || this.status != other.status && !this.status.equals((Object)other.status) || this.name != other.name && !this.name.equals(other.name) || this.groups != other.groups && !this.groups.equals(other.groups) || this.externalId != other.externalId && (this.externalId == null || !this.externalId.equals(other.externalId)));
        }
        return false;
    }

    @Override
    public String toString() {
        return this.serialize(false);
    }

    @Override
    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<TeamMemberProfile> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(TeamMemberProfile.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(TeamMemberProfile.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<TeamMemberProfile> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public TeamMemberProfile deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String teamMemberId = null;
            String email = null;
            Boolean emailVerified = null;
            TeamMemberStatus status = null;
            Name name = null;
            ArrayList<String> groups = null;
            String externalId = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("team_member_id".equals(_field)) {
                    teamMemberId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("email".equals(_field)) {
                    email = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("email_verified".equals(_field)) {
                    emailVerified = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("status".equals(_field)) {
                    status = _p.readValueAs(TeamMemberStatus.class);
                    _p.nextToken();
                    continue;
                }
                if ("name".equals(_field)) {
                    name = _p.readValueAs(Name.class);
                    _p.nextToken();
                    continue;
                }
                if ("groups".equals(_field)) {
                    Deserializer.expectArrayStart(_p);
                    groups = new ArrayList<String>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        String _x = null;
                        _x = Deserializer.getStringValue(_p);
                        _p.nextToken();
                        groups.add(_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    continue;
                }
                if ("external_id".equals(_field)) {
                    externalId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (teamMemberId == null) {
                throw new JsonParseException(_p, "Required field \"team_member_id\" is missing.");
            }
            if (email == null) {
                throw new JsonParseException(_p, "Required field \"email\" is missing.");
            }
            if (emailVerified == null) {
                throw new JsonParseException(_p, "Required field \"email_verified\" is missing.");
            }
            if (status == null) {
                throw new JsonParseException(_p, "Required field \"status\" is missing.");
            }
            if (name == null) {
                throw new JsonParseException(_p, "Required field \"name\" is missing.");
            }
            if (groups == null) {
                throw new JsonParseException(_p, "Required field \"groups\" is missing.");
            }
            return new TeamMemberProfile(teamMemberId, email, emailVerified, status, name, groups, externalId);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<TeamMemberProfile> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(TeamMemberProfile.class);
        }

        public Serializer(boolean unwrapping) {
            super(TeamMemberProfile.class, unwrapping);
        }

        @Override
        protected JsonSerializer<TeamMemberProfile> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(TeamMemberProfile value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("team_member_id", value.teamMemberId);
            g.writeObjectField("email", value.email);
            g.writeObjectField("email_verified", value.emailVerified);
            g.writeObjectField("status", (Object)value.status);
            g.writeObjectField("name", value.name);
            g.writeObjectField("groups", value.groups);
            if (value.externalId != null) {
                g.writeObjectField("external_id", value.externalId);
            }
        }
    }
}

