/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.users;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.users.Account;
import com.dropbox.core.v2.users.Name;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class BasicAccount
extends Account {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final boolean isTeammate;
    protected final String teamMemberId;

    public BasicAccount(String accountId, Name name, String email, boolean emailVerified, boolean isTeammate, String profilePhotoUrl, String teamMemberId) {
        super(accountId, name, email, emailVerified, profilePhotoUrl);
        this.isTeammate = isTeammate;
        this.teamMemberId = teamMemberId;
    }

    public BasicAccount(String accountId, Name name, String email, boolean emailVerified, boolean isTeammate) {
        this(accountId, name, email, emailVerified, isTeammate, null, null);
    }

    public boolean getIsTeammate() {
        return this.isTeammate;
    }

    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    public static Builder newBuilder(String accountId, Name name, String email, boolean emailVerified, boolean isTeammate) {
        return new Builder(accountId, name, email, emailVerified, isTeammate);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.isTeammate, this.teamMemberId});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            BasicAccount other = (BasicAccount)obj;
            return !(this.accountId != other.accountId && !this.accountId.equals(other.accountId) || this.name != other.name && !this.name.equals(other.name) || this.email != other.email && !this.email.equals(other.email) || this.emailVerified != other.emailVerified || this.isTeammate != other.isTeammate || this.profilePhotoUrl != other.profilePhotoUrl && (this.profilePhotoUrl == null || !this.profilePhotoUrl.equals(other.profilePhotoUrl)) || this.teamMemberId != other.teamMemberId && (this.teamMemberId == null || !this.teamMemberId.equals(other.teamMemberId)));
        }
        return false;
    }

    @Override
    public String toString() {
        return this.serialize(false);
    }

    @Override
    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<BasicAccount> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(BasicAccount.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(BasicAccount.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<BasicAccount> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public BasicAccount deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String accountId = null;
            Name name = null;
            String email = null;
            Boolean emailVerified = null;
            Boolean isTeammate = null;
            String profilePhotoUrl = null;
            String teamMemberId = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("account_id".equals(_field)) {
                    accountId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("name".equals(_field)) {
                    name = _p.readValueAs(Name.class);
                    _p.nextToken();
                    continue;
                }
                if ("email".equals(_field)) {
                    email = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("email_verified".equals(_field)) {
                    emailVerified = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("is_teammate".equals(_field)) {
                    isTeammate = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("profile_photo_url".equals(_field)) {
                    profilePhotoUrl = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("team_member_id".equals(_field)) {
                    teamMemberId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (accountId == null) {
                throw new JsonParseException(_p, "Required field \"account_id\" is missing.");
            }
            if (name == null) {
                throw new JsonParseException(_p, "Required field \"name\" is missing.");
            }
            if (email == null) {
                throw new JsonParseException(_p, "Required field \"email\" is missing.");
            }
            if (emailVerified == null) {
                throw new JsonParseException(_p, "Required field \"email_verified\" is missing.");
            }
            if (isTeammate == null) {
                throw new JsonParseException(_p, "Required field \"is_teammate\" is missing.");
            }
            return new BasicAccount(accountId, name, email, emailVerified, isTeammate, profilePhotoUrl, teamMemberId);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<BasicAccount> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(BasicAccount.class);
        }

        public Serializer(boolean unwrapping) {
            super(BasicAccount.class, unwrapping);
        }

        @Override
        protected JsonSerializer<BasicAccount> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(BasicAccount value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("account_id", value.accountId);
            g.writeObjectField("name", value.name);
            g.writeObjectField("email", value.email);
            g.writeObjectField("email_verified", value.emailVerified);
            g.writeObjectField("is_teammate", value.isTeammate);
            if (value.profilePhotoUrl != null) {
                g.writeObjectField("profile_photo_url", value.profilePhotoUrl);
            }
            if (value.teamMemberId != null) {
                g.writeObjectField("team_member_id", value.teamMemberId);
            }
        }
    }

    public static class Builder {
        protected final String accountId;
        protected final Name name;
        protected final String email;
        protected final boolean emailVerified;
        protected final boolean isTeammate;
        protected String profilePhotoUrl;
        protected String teamMemberId;

        protected Builder(String accountId, Name name, String email, boolean emailVerified, boolean isTeammate) {
            if (accountId == null) {
                throw new IllegalArgumentException("Required value for 'accountId' is null");
            }
            if (accountId.length() < 40) {
                throw new IllegalArgumentException("String 'accountId' is shorter than 40");
            }
            if (accountId.length() > 40) {
                throw new IllegalArgumentException("String 'accountId' is longer than 40");
            }
            this.accountId = accountId;
            if (name == null) {
                throw new IllegalArgumentException("Required value for 'name' is null");
            }
            this.name = name;
            if (email == null) {
                throw new IllegalArgumentException("Required value for 'email' is null");
            }
            this.email = email;
            this.emailVerified = emailVerified;
            this.isTeammate = isTeammate;
            this.profilePhotoUrl = null;
            this.teamMemberId = null;
        }

        public Builder withProfilePhotoUrl(String profilePhotoUrl) {
            this.profilePhotoUrl = profilePhotoUrl;
            return this;
        }

        public Builder withTeamMemberId(String teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public BasicAccount build() {
            return new BasicAccount(this.accountId, this.name, this.email, this.emailVerified, this.isTeammate, this.profilePhotoUrl, this.teamMemberId);
        }
    }
}

