/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.users;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class Team {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String id;
    protected final String name;

    public Team(String id, String name) {
        if (id == null) {
            throw new IllegalArgumentException("Required value for 'id' is null");
        }
        this.id = id;
        if (name == null) {
            throw new IllegalArgumentException("Required value for 'name' is null");
        }
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.id, this.name});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            Team other = (Team)obj;
            return !(this.id != other.id && !this.id.equals(other.id) || this.name != other.name && !this.name.equals(other.name));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<Team> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(Team.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(Team.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<Team> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public Team deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String id = null;
            String name = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("id".equals(_field)) {
                    id = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("name".equals(_field)) {
                    name = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (id == null) {
                throw new JsonParseException(_p, "Required field \"id\" is missing.");
            }
            if (name == null) {
                throw new JsonParseException(_p, "Required field \"name\" is missing.");
            }
            return new Team(id, name);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<Team> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(Team.class);
        }

        public Serializer(boolean unwrapping) {
            super(Team.class, unwrapping);
        }

        @Override
        protected JsonSerializer<Team> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(Team value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("id", value.id);
            g.writeObjectField("name", value.name);
        }
    }
}

