/*
 * Decompiled with CFR 0.152.
 */
package com.github.boly38.mongodump.services;

import com.dropbox.core.DbxDownloader;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.http.StandardHttpRequestor;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.DownloadErrorException;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.ListFolderErrorException;
import com.dropbox.core.v2.files.Metadata;
import com.dropbox.core.v2.files.UploadErrorException;
import com.dropbox.core.v2.users.FullAccount;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropboxService {
    private static final Logger log = LoggerFactory.getLogger(DropboxService.class);
    public static final String DEFAULT_APP_NAME = "dropbox/Applications/MongoWrapper";
    public static final String DROPBOX_TOKEN_KEY = "DROPBOX_TOKEN";
    public static final String DROPBOX_APPLICATION_KEY = "DROPBOX_APPLICATION";
    private DbxClientV2 dboxClient = null;

    public DropboxService() {
        this._initClient();
    }

    private void warnUsage() {
        String notTokenMsg = String.format("no dropbox token defined, env:%s is not set", DROPBOX_TOKEN_KEY);
        log.warn(notTokenMsg);
    }

    private String getDropBoxToken() {
        boolean tokenIsSet;
        String token = System.getenv(DROPBOX_TOKEN_KEY);
        boolean bl = tokenIsSet = token != null && !token.isEmpty();
        if (!tokenIsSet) {
            return null;
        }
        return token;
    }

    private String getDropBoxAppName() {
        boolean appIsSet;
        String appName = System.getenv(DROPBOX_APPLICATION_KEY);
        boolean bl = appIsSet = appName != null && !appName.isEmpty();
        if (!appIsSet) {
            return DEFAULT_APP_NAME;
        }
        return appName;
    }

    private HttpRequestor getProxyRequestor() {
        String proxyHost = System.getProperty("https.proxyHost", "");
        if (proxyHost == null || proxyHost.isEmpty()) {
            return null;
        }
        String proxyPortString = System.getProperty("https.proxyPort", "80");
        int proxyPort = 80;
        try {
            proxyPort = Integer.parseInt(proxyPortString);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalStateException(String.format("invalid proxy port '%s'", proxyPortString));
        }
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
        StandardHttpRequestor.Config conf = StandardHttpRequestor.Config.builder().withProxy(proxy).build();
        StandardHttpRequestor req = new StandardHttpRequestor(conf);
        log.info("use proxy {}:{}", (Object)proxyHost, (Object)proxyPort);
        return req;
    }

    private void _initClient() {
        String localeString = Locale.getDefault().toString();
        String appName = this.getDropBoxAppName();
        String token = this.getDropBoxToken();
        if (token == null || token.isEmpty()) {
            return;
        }
        HttpRequestor requ = this.getProxyRequestor();
        DbxRequestConfig config = requ != null ? new DbxRequestConfig(appName, localeString, requ) : new DbxRequestConfig(appName, localeString);
        this.dboxClient = new DbxClientV2(config, token);
        log.debug("connected to dropbox application '{}'", (Object)appName);
    }

    public void assumeAvailable() {
        if (!this.isAvailable()) {
            this.warnUsage();
            throw new IllegalStateException("DropBox client is not available");
        }
    }

    public boolean isAvailable() {
        return this.dboxClient != null;
    }

    public String getAccount() throws DbxException {
        this.assumeAvailable();
        FullAccount account = this.dboxClient.users().getCurrentAccount();
        return account.getName().getDisplayName();
    }

    public List<Metadata> listFolder(String folderName) throws ListFolderErrorException, DbxException {
        this.assumeAvailable();
        return this.dboxClient.files().listFolder(folderName).getEntries();
    }

    public FileMetadata uploadFile(String localFilename, String dboxFilename) throws FileNotFoundException, IOException, UploadErrorException, DbxException {
        this.assumeAvailable();
        try (FileInputStream in = new FileInputStream(localFilename);){
            FileMetadata metadata;
            FileMetadata fileMetadata = metadata = (FileMetadata)this.dboxClient.files().uploadBuilder(dboxFilename).uploadAndFinish(in);
            return fileMetadata;
        }
    }

    public String downloadFile(String dboxFilename) throws IOException, DownloadErrorException, DbxException {
        File tmpFile = File.createTempFile("dropbox-downloaded-file", ".tmp");
        DbxDownloader<FileMetadata> download = this.dboxClient.files().download(dboxFilename);
        FileOutputStream fOut = new FileOutputStream(tmpFile);
        download.download(fOut);
        String filePath = tmpFile.getAbsolutePath();
        ((OutputStream)fOut).close();
        return filePath;
    }
}

