/*
 * Decompiled with CFR 0.152.
 */
package com.github.boly38.mongodump.services;

import com.github.boly38.mongodump.domain.BackupConfiguration;
import com.github.boly38.mongodump.domain.BackupException;
import com.github.boly38.mongodump.domain.MongoServerHostConfiguration;
import com.github.boly38.mongodump.domain.RestoreConfiguration;
import com.github.boly38.mongodump.domain.RestoreException;
import com.github.boly38.mongodump.domain.SpyLogs;
import com.github.boly38.mongodump.domain.StreamPrinter;
import java.io.IOException;
import java.security.InvalidParameterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongodumpService {
    private static final Logger log = LoggerFactory.getLogger(MongodumpService.class);
    private MongoServerHostConfiguration hostConfig;

    private MongodumpService() {
    }

    public static MongodumpService getInstance(MongoServerHostConfiguration hostConf) {
        MongodumpService svc = new MongodumpService();
        svc.setHostConfig(hostConf);
        return svc;
    }

    private void notEmpty(String val, String error) {
        if (val == null || val.isEmpty()) {
            throw new InvalidParameterException(error);
        }
    }

    public synchronized String backup(BackupConfiguration backupConf) throws BackupException {
        String db = backupConf != null ? backupConf.getDbName() : null;
        this.notEmpty(db, "database name is required");
        String cmd = this.getHostConfig().getMongoDumpBinAbsolutePath();
        String collection = backupConf != null ? backupConf.getCollectionName() : null;
        String finalBackupName = backupConf != null ? backupConf.getAbsoluteBackupName() : null;
        return this._backupCmd(cmd, db, collection, finalBackupName);
    }

    private String _backupCmd(String cmd, String db, String collection, String finalBackupName) throws BackupException {
        log.info("backup cmd:{}, db:{}, collection:{}, finalZipName:{}", cmd, db, collection != null ? collection : "(not set)", finalBackupName);
        String archiveOption = String.format("/archive:%s", finalBackupName);
        ProcessBuilder builder = collection != null ? new ProcessBuilder(cmd, archiveOption, "--gzip", "--db", db, "--collection", collection) : new ProcessBuilder(cmd, archiveOption, "--gzip", "--db", db);
        try {
            SpyLogs spyLogs = new SpyLogs();
            SpyLogs spyErrorLogs = new SpyLogs();
            int errorId = spyErrorLogs.addSpy("error");
            Process process = builder.start();
            log.info("please notice that mongodump reports all dump action into stderr (not only errors)");
            StreamPrinter fluxErreur = new StreamPrinter("[mongodump.exe ERR]", process.getErrorStream(), spyErrorLogs);
            StreamPrinter fluxSortie = new StreamPrinter("[mongodump.exe]", process.getInputStream(), spyLogs);
            fluxErreur.start();
            fluxSortie.start();
            process.waitFor();
            int exitValue = process.exitValue();
            if (exitValue == 0) {
                log.info("BACKUP created : {}", (Object)finalBackupName);
                return finalBackupName;
            }
            String errorMsg = null;
            if (!spyErrorLogs.hasSpy(errorId)) {
                errorMsg = spyErrorLogs.getRecorderdSpy(errorId);
            }
            throw new BackupException(exitValue, errorMsg);
        }
        catch (IOException e) {
            String errMsg = String.format("Error during the backup of '%s' : %s", db, e.getMessage());
            log.error(errMsg, e);
            throw new BackupException(errMsg);
        }
        catch (InterruptedException e) {
            String errMsg = String.format("Interruption during the backup of '{}' : {}", db, e.getMessage());
            log.error(errMsg, e);
            throw new BackupException(errMsg);
        }
    }

    public synchronized void restore(RestoreConfiguration restoreConf) throws RestoreException {
        String db = restoreConf != null ? restoreConf.getDbName() : null;
        this.notEmpty(db, "database name is required");
        String cmd = this.getHostConfig().getMongoRestoreBinAbsolutePath();
        String collection = restoreConf != null ? restoreConf.getCollectionName() : null;
        String backupFile = restoreConf != null ? restoreConf.getBackupFile() : null;
        this._restoreCmd(cmd, db, collection, backupFile);
    }

    private void _restoreCmd(String cmd, String db, String collection, String backupFile) throws RestoreException {
        log.info("restore cmd:{}, db:{}, collection:{}, backupFile:{}", cmd, db, collection != null ? collection : "(not set)", backupFile);
        String archiveOption = String.format("/archive:%s", backupFile);
        ProcessBuilder builder = collection != null ? new ProcessBuilder(cmd, archiveOption, "--gzip", "-v", "--drop", "--db", db, "--collection", collection) : new ProcessBuilder(cmd, archiveOption, "--gzip", "-v", "--drop", "--db", db);
        try {
            SpyLogs spyLogs = new SpyLogs();
            SpyLogs spyErrorLogs = new SpyLogs();
            int errorId = spyErrorLogs.addSpy("error");
            int failedId = spyErrorLogs.addSpy("Failed");
            Process process = builder.start();
            log.info("please notice that mongorestore reports all restore action into stderr (not only errors)");
            StreamPrinter fluxErreur = new StreamPrinter("[mongorestore.exe ERR]", process.getErrorStream(), spyErrorLogs);
            StreamPrinter fluxSortie = new StreamPrinter("[mongorestore.exe]", process.getInputStream(), spyLogs);
            fluxErreur.start();
            fluxSortie.start();
            process.waitFor();
            int exitValue = process.exitValue();
            if (exitValue == 0) {
                log.info("restored with success : {}", (Object)backupFile);
                return;
            }
            String errorMsg = null;
            if (!spyErrorLogs.hasSpy(errorId)) {
                errorMsg = spyErrorLogs.getRecorderdSpy(errorId);
                throw new RestoreException(exitValue, errorMsg);
            }
            if (!spyErrorLogs.hasSpy(failedId)) {
                errorMsg = spyErrorLogs.getRecorderdSpy(errorId);
                throw new RestoreException(exitValue, errorMsg);
            }
        }
        catch (IOException e) {
            String errMsg = String.format("Error during the restore of '%s' : %s", db, e.getMessage());
            log.error(errMsg, e);
            throw new RestoreException(errMsg);
        }
        catch (InterruptedException e) {
            String errMsg = String.format("Interruption during the of of '{}' : {}", db, e.getMessage());
            log.error(errMsg, e);
            throw new RestoreException(errMsg);
        }
    }

    public MongoServerHostConfiguration getHostConfig() {
        return this.hostConfig;
    }

    public void setHostConfig(MongoServerHostConfiguration hostConfig) {
        this.hostConfig = hostConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MongodumpService)) {
            return false;
        }
        MongodumpService other = (MongodumpService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MongoServerHostConfiguration this$hostConfig = this.getHostConfig();
        MongoServerHostConfiguration other$hostConfig = other.getHostConfig();
        return !(this$hostConfig == null ? other$hostConfig != null : !((Object)this$hostConfig).equals(other$hostConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MongodumpService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MongoServerHostConfiguration $hostConfig = this.getHostConfig();
        result = result * 59 + ($hostConfig == null ? 43 : ((Object)$hostConfig).hashCode());
        return result;
    }

    public String toString() {
        return "MongodumpService(hostConfig=" + this.getHostConfig() + ")";
    }
}

