/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api;

import java.util.Comparator;
import java.util.List;
import org.fest.assertions.api.AbstractIterableAssert;
import org.fest.assertions.core.Condition;
import org.fest.assertions.core.IndexedObjectEnumerableAssert;
import org.fest.assertions.data.Index;
import org.fest.assertions.internal.ComparatorBasedComparisonStrategy;
import org.fest.assertions.internal.Lists;
import org.fest.util.VisibleForTesting;

public class ListAssert<T>
extends AbstractIterableAssert<ListAssert<T>, List<T>, T>
implements IndexedObjectEnumerableAssert<ListAssert<T>, T> {
    @VisibleForTesting
    Lists lists = Lists.instance();

    protected ListAssert(List<T> actual) {
        super(actual, ListAssert.class);
    }

    @Override
    public ListAssert<T> contains(T value, Index index) {
        this.lists.assertContains(this.info, (List)this.actual, value, index);
        return this;
    }

    @Override
    public ListAssert<T> doesNotContain(T value, Index index) {
        this.lists.assertDoesNotContain(this.info, (List)this.actual, value, index);
        return this;
    }

    public ListAssert<T> has(Condition<? super T> condition, Index index) {
        this.lists.assertHas(this.info, (List)this.actual, condition, index);
        return this;
    }

    public ListAssert<T> is(Condition<? super T> condition, Index index) {
        this.lists.assertIs(this.info, (List)this.actual, condition, index);
        return this;
    }

    public ListAssert<T> isSorted() {
        this.lists.assertIsSorted(this.info, (List)this.actual);
        return this;
    }

    public ListAssert<T> isSortedAccordingTo(Comparator<? super T> comparator) {
        this.lists.assertIsSortedAccordingToComparator(this.info, (List)this.actual, comparator);
        return this;
    }

    @Override
    public ListAssert<T> usingElementComparator(Comparator<? super T> customComparator) {
        super.usingElementComparator((Comparator)customComparator);
        this.lists = new Lists(new ComparatorBasedComparisonStrategy(customComparator));
        return (ListAssert)this.myself;
    }

    @Override
    public ListAssert<T> usingDefaultElementComparator() {
        super.usingDefaultElementComparator();
        this.lists = Lists.instance();
        return (ListAssert)this.myself;
    }
}

