/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.internal;

import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.error.ShouldBeLowerCase;
import org.fest.assertions.error.ShouldBeUpperCase;
import org.fest.assertions.internal.Comparables;
import org.fest.assertions.internal.ComparisonStrategy;
import org.fest.util.VisibleForTesting;

public class Characters
extends Comparables {
    private static final Characters INSTANCE = new Characters();

    public static Characters instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Characters() {
    }

    public Characters(ComparisonStrategy comparisonStrategy) {
        super(comparisonStrategy);
    }

    public void assertLowerCase(AssertionInfo info, Character actual) {
        Characters.assertNotNull(info, actual);
        if (Character.isLowerCase(actual.charValue())) {
            return;
        }
        throw this.failures.failure(info, ShouldBeLowerCase.shouldBeLowerCase(actual));
    }

    public void assertUpperCase(AssertionInfo info, Character actual) {
        Characters.assertNotNull(info, actual);
        if (Character.isUpperCase(actual.charValue())) {
            return;
        }
        throw this.failures.failure(info, ShouldBeUpperCase.shouldBeUpperCase(actual));
    }
}

