/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.http.StandardHttpRequestor;

public class DbxRequestConfig {
    private final String clientIdentifier;
    private final String userLocale;
    private final HttpRequestor httpRequestor;
    private final int maxRetries;

    private DbxRequestConfig(String clientIdentifier, String userLocale, HttpRequestor httpRequestor, int maxRetries) {
        if (clientIdentifier == null) {
            throw new NullPointerException("clientIdentifier");
        }
        if (httpRequestor == null) {
            throw new NullPointerException("httpRequestor");
        }
        if (maxRetries < 0) {
            throw new IllegalArgumentException("maxRetries");
        }
        this.clientIdentifier = clientIdentifier;
        this.userLocale = userLocale;
        this.httpRequestor = httpRequestor;
        this.maxRetries = maxRetries;
    }

    public DbxRequestConfig(String clientIdentifier, String userLocale) {
        this(clientIdentifier, userLocale, StandardHttpRequestor.INSTANCE);
    }

    public DbxRequestConfig(String clientIdentifier, String userLocale, HttpRequestor httpRequestor) {
        this(clientIdentifier, userLocale, httpRequestor, 0);
    }

    public String getClientIdentifier() {
        return this.clientIdentifier;
    }

    public String getUserLocale() {
        return this.userLocale;
    }

    public HttpRequestor getHttpRequestor() {
        return this.httpRequestor;
    }

    public boolean isAutoRetryEnabled() {
        return this.maxRetries > 0;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public Builder copy() {
        return new Builder(this.clientIdentifier, this.userLocale, this.httpRequestor, this.maxRetries);
    }

    public static Builder newBuilder(String clientIdentifier) {
        if (clientIdentifier == null) {
            throw new NullPointerException("clientIdentifier");
        }
        return new Builder(clientIdentifier);
    }

    public static final class Builder {
        private final String clientIdentifier;
        private String userLocale;
        private HttpRequestor httpRequestor;
        private int maxRetries;

        private Builder(String clientIdentifier, String userLocale, HttpRequestor httpRequestor, int maxRetries) {
            this.clientIdentifier = clientIdentifier;
            this.userLocale = userLocale;
            this.httpRequestor = httpRequestor;
            this.maxRetries = maxRetries;
        }

        private Builder(String clientIdentifier) {
            this.clientIdentifier = clientIdentifier;
            this.userLocale = null;
            this.httpRequestor = StandardHttpRequestor.INSTANCE;
            this.maxRetries = 0;
        }

        public Builder withUserLocale(String userLocale) {
            this.userLocale = userLocale;
            return this;
        }

        public Builder withHttpRequestor(HttpRequestor httpRequestor) {
            if (httpRequestor == null) {
                throw new NullPointerException("httpRequestor");
            }
            this.httpRequestor = httpRequestor;
            return this;
        }

        public Builder withAutoRetryEnabled() {
            return this.withAutoRetryEnabled(3);
        }

        public Builder withAutoRetryDisabled() {
            this.maxRetries = 0;
            return this;
        }

        public Builder withAutoRetryEnabled(int maxRetries) {
            if (maxRetries <= 0) {
                throw new IllegalArgumentException("maxRetries must be positive");
            }
            this.maxRetries = maxRetries;
            return this;
        }

        public DbxRequestConfig build() {
            return new DbxRequestConfig(this.clientIdentifier, this.userLocale, this.httpRequestor, this.maxRetries);
        }
    }
}

