/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import com.dropbox.core.BadResponseException;
import com.dropbox.core.DbxApiException;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxRequestUtil;
import com.dropbox.core.NetworkIOException;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.util.IOUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class DbxUploader<R, E, X extends DbxApiException>
implements Closeable {
    protected static final ObjectMapper JSON = JsonUtil.getMapper();
    private final HttpRequestor.Uploader httpUploader;
    private final JavaType responseType;
    private final JavaType errorType;
    private boolean closed;
    private boolean finished;

    protected DbxUploader(HttpRequestor.Uploader httpUploader, JavaType responseType, JavaType errorType) {
        this.httpUploader = httpUploader;
        this.responseType = responseType;
        this.errorType = errorType;
        this.closed = false;
        this.finished = false;
    }

    protected abstract X newException(DbxRequestUtil.ErrorWrapper var1);

    public R uploadAndFinish(InputStream in) throws X, DbxException, IOException {
        try {
            try {
                IOUtil.copyStreamToStream(in, this.getOutputStream());
            }
            catch (IOUtil.ReadException ex) {
                throw ex.getCause();
            }
            catch (IOException ex) {
                throw new NetworkIOException(ex);
            }
            R r = this.finish();
            return r;
        }
        finally {
            this.close();
        }
    }

    public R uploadAndFinish(InputStream in, long limit) throws X, DbxException, IOException {
        return this.uploadAndFinish(IOUtil.limit(in, limit));
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.httpUploader.close();
            this.closed = true;
        }
    }

    public void abort() {
        this.httpUploader.abort();
    }

    public OutputStream getOutputStream() {
        this.assertOpenAndUnfinished();
        return this.httpUploader.getBody();
    }

    /*
     * Loose catch block
     */
    public R finish() throws X, DbxException {
        this.assertOpenAndUnfinished();
        HttpRequestor.Response response = null;
        try {
            block11: {
                response = this.httpUploader.finish();
                if (response.getStatusCode() != 200) break block11;
                Object t = JSON.readValue(response.getBody(), this.responseType);
                {
                    catch (JsonProcessingException ex) {
                        String requestId = DbxRequestUtil.getRequestId(response);
                        throw new BadResponseException(requestId, "Bad JSON in response: " + ex, ex);
                    }
                }
                return (R)t;
            }
            try {
                if (response.getStatusCode() == 409) {
                    DbxRequestUtil.ErrorWrapper wrapper = DbxRequestUtil.ErrorWrapper.fromResponse(this.errorType, response);
                    throw this.newException(wrapper);
                }
                throw DbxRequestUtil.unexpectedStatus(response);
            }
            catch (IOException ex) {
                throw new NetworkIOException(ex);
            }
        }
        finally {
            if (response != null) {
                IOUtil.closeQuietly(response.getBody());
            }
            this.finished = true;
        }
    }

    private void assertOpenAndUnfinished() {
        if (this.closed) {
            throw new IllegalStateException("This uploader is already closed.");
        }
        if (this.finished) {
            throw new IllegalStateException("This uploader is already finished and cannot be used to upload more data.");
        }
    }
}

