/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import com.dropbox.core.DbxAppInfo;
import com.dropbox.core.DbxAuthFinish;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.DbxRequestUtil;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.util.StringUtil;
import java.util.ArrayList;

abstract class DbxWebAuthHelper {
    DbxWebAuthHelper() {
    }

    public static String getAuthorizeUrl(DbxAppInfo appInfo, String userLocale, String redirectUri, String state) {
        return DbxRequestUtil.buildUrlWithParams(userLocale, appInfo.getHost().getWeb(), "1/oauth2/authorize", new String[]{"client_id", appInfo.getKey(), "response_type", "code", "redirect_uri", redirectUri, "state", state});
    }

    public static DbxAuthFinish finish(DbxAppInfo appInfo, DbxRequestConfig requestConfig, String code, String originalRedirectUri) throws DbxException {
        if (code == null) {
            throw new IllegalArgumentException("'code' can't be null");
        }
        String[] params = new String[]{"grant_type", "authorization_code", "code", code, "redirect_uri", originalRedirectUri, "locale", requestConfig.getUserLocale()};
        ArrayList<HttpRequestor.Header> headers = new ArrayList<HttpRequestor.Header>();
        String credentials = appInfo.getKey() + ":" + appInfo.getSecret();
        String base64Credentials = StringUtil.base64Encode(StringUtil.stringToUtf8(credentials));
        headers.add(new HttpRequestor.Header("Authorization", "Basic " + base64Credentials));
        return DbxRequestUtil.doPostNoAuth(requestConfig, "Dropbox-Java-SDK", appInfo.getHost().getApi(), "1/oauth2/token", params, headers, new DbxRequestUtil.ResponseHandler<DbxAuthFinish>(){

            @Override
            public DbxAuthFinish handle(HttpRequestor.Response response) throws DbxException {
                if (response.getStatusCode() != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return DbxRequestUtil.readJsonFromResponse(DbxAuthFinish.Reader, response);
            }
        });
    }
}

