/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.http;

import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.http.SSLConfig;
import com.dropbox.core.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Proxy;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;

public class StandardHttpRequestor
extends HttpRequestor {
    public static final StandardHttpRequestor INSTANCE = new StandardHttpRequestor(Config.DEFAULT_INSTANCE);
    private final Config config;

    public StandardHttpRequestor(Config config) {
        this.config = config;
    }

    private static HttpRequestor.Response toResponse(HttpsURLConnection conn) throws IOException {
        int responseCode = conn.getResponseCode();
        InputStream bodyStream = responseCode >= 400 ? conn.getErrorStream() : conn.getInputStream();
        return new HttpRequestor.Response(responseCode, bodyStream, conn.getHeaderFields());
    }

    @Override
    public HttpRequestor.Response doGet(String url, Iterable<HttpRequestor.Header> headers) throws IOException {
        HttpsURLConnection conn = this.prepRequest(url, headers);
        conn.setRequestMethod("GET");
        conn.connect();
        return StandardHttpRequestor.toResponse(conn);
    }

    @Override
    public Uploader startPost(String url, Iterable<HttpRequestor.Header> headers) throws IOException {
        HttpsURLConnection conn = this.prepRequest(url, headers);
        conn.setRequestMethod("POST");
        return new Uploader(conn);
    }

    @Override
    public Uploader startPut(String url, Iterable<HttpRequestor.Header> headers) throws IOException {
        HttpsURLConnection conn = this.prepRequest(url, headers);
        conn.setRequestMethod("PUT");
        return new Uploader(conn);
    }

    protected void configureConnection(HttpsURLConnection conn) throws IOException {
    }

    private HttpsURLConnection prepRequest(String url, Iterable<HttpRequestor.Header> headers) throws IOException {
        URL urlObject = new URL(url);
        HttpsURLConnection conn = (HttpsURLConnection)urlObject.openConnection(this.config.getProxy());
        SSLConfig.apply(conn);
        conn.setConnectTimeout((int)this.config.getConnectTimeoutMillis());
        conn.setReadTimeout((int)this.config.getReadTimeoutMillis());
        conn.setUseCaches(false);
        conn.setAllowUserInteraction(false);
        this.configureConnection(conn);
        for (HttpRequestor.Header header : headers) {
            conn.addRequestProperty(header.getKey(), header.getValue());
        }
        return conn;
    }

    public static final class Config {
        public static final Config DEFAULT_INSTANCE = Config.builder().build();
        private final Proxy proxy;
        private final long connectTimeoutMillis;
        private final long readTimeoutMillis;

        private Config(Proxy proxy, long connectTimeoutMillis, long readTimeoutMillis) {
            this.proxy = proxy;
            this.connectTimeoutMillis = connectTimeoutMillis;
            this.readTimeoutMillis = readTimeoutMillis;
        }

        public Proxy getProxy() {
            return this.proxy;
        }

        public long getConnectTimeoutMillis() {
            return this.connectTimeoutMillis;
        }

        public long getReadTimeoutMillis() {
            return this.readTimeoutMillis;
        }

        public Builder copy() {
            return new Builder(this.proxy, this.connectTimeoutMillis, this.readTimeoutMillis);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Proxy proxy;
            private long connectTimeoutMillis;
            private long readTimeoutMillis;

            private Builder() {
                this(Proxy.NO_PROXY, HttpRequestor.DEFAULT_CONNECT_TIMEOUT_MILLIS, HttpRequestor.DEFAULT_READ_TIMEOUT_MILLIS);
            }

            private Builder(Proxy proxy, long connectTimeoutMillis, long readTimeoutMillis) {
                this.proxy = proxy;
                this.connectTimeoutMillis = connectTimeoutMillis;
                this.readTimeoutMillis = readTimeoutMillis;
            }

            public Builder withProxy(Proxy proxy) {
                if (proxy == null) {
                    throw new NullPointerException("proxy");
                }
                this.proxy = proxy;
                return this;
            }

            public Builder withNoConnectTimeout() {
                return this.withConnectTimeout(0L, TimeUnit.MILLISECONDS);
            }

            public Builder withConnectTimeout(long timeout, TimeUnit unit) {
                this.connectTimeoutMillis = Builder.checkTimeoutMillis(timeout, unit);
                return this;
            }

            public Builder withNoReadTimeout() {
                return this.withReadTimeout(0L, TimeUnit.MILLISECONDS);
            }

            public Builder withReadTimeout(long timeout, TimeUnit unit) {
                this.readTimeoutMillis = Builder.checkTimeoutMillis(timeout, unit);
                return this;
            }

            public Config build() {
                return new Config(this.proxy, this.connectTimeoutMillis, this.readTimeoutMillis);
            }

            private static long checkTimeoutMillis(long timeout, TimeUnit unit) {
                if (unit == null) {
                    throw new NullPointerException("unit");
                }
                if (timeout < 0L) {
                    throw new IllegalArgumentException("timeout must be non-negative");
                }
                long millis = unit.toMillis(timeout);
                if (Integer.MAX_VALUE < millis) {
                    throw new IllegalArgumentException("timeout too large, must be less than: 2147483647");
                }
                return millis;
            }
        }
    }

    private static class Uploader
    extends HttpRequestor.Uploader {
        private HttpsURLConnection conn;

        public Uploader(HttpsURLConnection conn) throws IOException {
            super(Uploader.getOutputStream(conn));
            conn.connect();
            this.conn = conn;
        }

        private static OutputStream getOutputStream(HttpsURLConnection conn) throws IOException {
            conn.setDoOutput(true);
            return conn.getOutputStream();
        }

        @Override
        public void abort() {
            if (this.conn == null) {
                throw new IllegalStateException("Can't abort().  Uploader already closed.");
            }
            this.conn.disconnect();
            this.conn = null;
        }

        @Override
        public void close() {
            if (this.conn == null) {
                return;
            }
            if (this.conn.getDoOutput()) {
                try {
                    IOUtil.closeQuietly(this.conn.getOutputStream());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.conn = null;
        }

        @Override
        public HttpRequestor.Response finish() throws IOException {
            if (this.conn == null) {
                throw new IllegalStateException("Can't finish().  Uploader already closed.");
            }
            try {
                HttpRequestor.Response response = StandardHttpRequestor.toResponse(this.conn);
                return response;
            }
            finally {
                this.conn = null;
            }
        }
    }
}

