/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2;

import com.dropbox.core.BadResponseException;
import com.dropbox.core.DbxDownloader;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxHost;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.DbxRequestUtil;
import com.dropbox.core.NetworkIOException;
import com.dropbox.core.RetryException;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.util.LangUtil;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DbxRawClientV2 {
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final List<Integer> FUNCTION_SPECIFIC_ERROR_CODES = Arrays.asList(403, 404, 409);
    private static final String USER_AGENT_ID = "OfficialDropboxJavaSDKv2";
    private static final ObjectMapper JSON = JsonUtil.getMapper();
    private final DbxRequestConfig requestConfig;
    private final String accessToken;
    private final DbxHost host;

    public DbxRawClientV2(DbxRequestConfig requestConfig, String accessToken, DbxHost host) {
        if (requestConfig == null) {
            throw new NullPointerException("requestConfig");
        }
        if (accessToken == null) {
            throw new NullPointerException("accessToken");
        }
        if (host == null) {
            throw new NullPointerException("host");
        }
        this.requestConfig = requestConfig;
        this.accessToken = accessToken;
        this.host = host;
    }

    public DbxRawClientV2(DbxRequestConfig requestConfig, String accessToken) {
        this(requestConfig, accessToken, DbxHost.DEFAULT);
    }

    DbxRawClientV2(DbxRawClientV2 copy) {
        this.requestConfig = copy.requestConfig;
        this.accessToken = copy.accessToken;
        this.host = copy.host;
    }

    protected void addAuthHeaders(List<HttpRequestor.Header> headers) {
        DbxRequestUtil.addAuthHeader(headers, this.accessToken);
    }

    public <ArgT, ResT, ErrT> ResT rpcStyle(final String host, final String path, ArgT arg, boolean noAuth, final JavaType responseType, final JavaType errorType) throws DbxRequestUtil.ErrorWrapper, DbxException {
        final byte[] body = DbxRawClientV2.writeAsBytes(arg);
        final ArrayList<HttpRequestor.Header> headers = new ArrayList<HttpRequestor.Header>();
        if (!noAuth) {
            this.addAuthHeaders(headers);
        }
        headers.add(new HttpRequestor.Header("Content-Type", "application/json; charset=utf-8"));
        return (ResT)DbxRawClientV2.executeRetriable(this.requestConfig.getMaxRetries(), new RetriableExecution<ResT>(){

            @Override
            public ResT execute() throws DbxRequestUtil.ErrorWrapper, DbxException {
                HttpRequestor.Response response = DbxRequestUtil.startPostRaw(DbxRawClientV2.this.requestConfig, DbxRawClientV2.USER_AGENT_ID, host, path, body, headers);
                try {
                    if (response.getStatusCode() == 200) {
                        return JSON.readValue(response.getBody(), responseType);
                    }
                    if (FUNCTION_SPECIFIC_ERROR_CODES.contains(response.getStatusCode())) {
                        throw DbxRequestUtil.ErrorWrapper.fromResponse(errorType, response);
                    }
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                catch (JsonProcessingException ex) {
                    String requestId = DbxRequestUtil.getRequestId(response);
                    throw new BadResponseException(requestId, "Bad JSON: " + ex.getMessage(), ex);
                }
                catch (IOException ex) {
                    throw new NetworkIOException(ex);
                }
            }
        });
    }

    public <ArgT, ResT, ErrT> DbxDownloader<ResT> downloadStyle(final String host, final String path, ArgT arg, boolean noAuth, final JavaType responseType, final JavaType errorType) throws DbxRequestUtil.ErrorWrapper, DbxException {
        final ArrayList<HttpRequestor.Header> headers = new ArrayList<HttpRequestor.Header>();
        if (!noAuth) {
            this.addAuthHeaders(headers);
        }
        headers.add(new HttpRequestor.Header("Dropbox-API-Arg", DbxRawClientV2.headerSafeJson(arg)));
        headers.add(new HttpRequestor.Header("Content-Type", ""));
        final byte[] body = new byte[]{};
        return (DbxDownloader)DbxRawClientV2.executeRetriable(this.requestConfig.getMaxRetries(), new RetriableExecution<DbxDownloader<ResT>>(){

            @Override
            public DbxDownloader<ResT> execute() throws DbxRequestUtil.ErrorWrapper, DbxException {
                HttpRequestor.Response response = DbxRequestUtil.startPostRaw(DbxRawClientV2.this.requestConfig, DbxRawClientV2.USER_AGENT_ID, host, path, body, headers);
                String requestId = DbxRequestUtil.getRequestId(response);
                try {
                    if (response.getStatusCode() == 200) {
                        List<String> resultHeaders = response.getHeaders().get("dropbox-api-result");
                        if (resultHeaders == null) {
                            throw new BadResponseException(requestId, "Missing Dropbox-API-Result header; " + response.getHeaders());
                        }
                        if (resultHeaders.size() == 0) {
                            throw new BadResponseException(requestId, "No Dropbox-API-Result header; " + response.getHeaders());
                        }
                        String resultHeader = resultHeaders.get(0);
                        if (resultHeader == null) {
                            throw new BadResponseException(requestId, "Null Dropbox-API-Result header; " + response.getHeaders());
                        }
                        Object result = JSON.readValue(resultHeader, responseType);
                        return new DbxDownloader(result, response.getBody());
                    }
                    if (FUNCTION_SPECIFIC_ERROR_CODES.contains(response.getStatusCode())) {
                        throw DbxRequestUtil.ErrorWrapper.fromResponse(errorType, response);
                    }
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                catch (JsonProcessingException ex) {
                    throw new BadResponseException(requestId, "Bad JSON: " + ex.getMessage(), ex);
                }
                catch (IOException ex) {
                    throw new NetworkIOException(ex);
                }
            }
        });
    }

    private static <T> byte[] writeAsBytes(T arg) throws DbxException {
        try {
            return JSON.writeValueAsBytes(arg);
        }
        catch (JsonProcessingException ex) {
            throw LangUtil.mkAssert("Failed to serialize argument", ex);
        }
        catch (IOException ex) {
            throw new NetworkIOException(ex);
        }
    }

    private static <T> String headerSafeJson(T value) {
        StringWriter out = new StringWriter();
        try {
            JsonGenerator g = JSON.getFactory().createGenerator(out);
            g.setHighestNonEscapedChar(126);
            JSON.writeValue(g, value);
            g.flush();
        }
        catch (IOException ex) {
            throw LangUtil.mkAssert("Impossible", ex);
        }
        return out.toString();
    }

    public <ArgT> HttpRequestor.Uploader uploadStyle(String host, String path, ArgT arg, boolean noAuth) throws DbxException {
        String uri = DbxRequestUtil.buildUri(host, path);
        List<HttpRequestor.Header> headers = new ArrayList<HttpRequestor.Header>();
        if (!noAuth) {
            this.addAuthHeaders(headers);
        }
        headers.add(new HttpRequestor.Header("Content-Type", "application/octet-stream"));
        headers = DbxRequestUtil.addUserAgentHeader(headers, this.requestConfig, USER_AGENT_ID);
        headers.add(new HttpRequestor.Header("Dropbox-API-Arg", DbxRawClientV2.headerSafeJson(arg)));
        try {
            return this.requestConfig.getHttpRequestor().startPost(uri, headers);
        }
        catch (IOException ex) {
            throw new NetworkIOException(ex);
        }
    }

    public DbxRequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public DbxHost getHost() {
        return this.host;
    }

    private static <T> T executeRetriable(int maxRetries, RetriableExecution<T> execution) throws DbxRequestUtil.ErrorWrapper, DbxException {
        if (maxRetries == 0) {
            return execution.execute();
        }
        int retries = 0;
        while (true) {
            try {
                return execution.execute();
            }
            catch (RetryException ex) {
                if (retries < maxRetries) {
                    ++retries;
                    DbxRawClientV2.sleepQuietly(ex.getBackoffMillis());
                    continue;
                }
                throw ex;
            }
            break;
        }
    }

    private static void sleepQuietly(long millis) {
        if (millis <= 0L) {
            return;
        }
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private static interface RetriableExecution<T> {
        public T execute() throws DbxRequestUtil.ErrorWrapper, DbxException;
    }
}

