/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2;

import com.dropbox.core.DbxHost;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.DbxRequestUtil;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.team.DbxTeamTeamRequests;
import java.util.List;

public final class DbxTeamClientV2 {
    private final DbxRawClientV2 _client;
    private final DbxTeamTeamRequests team;

    public DbxTeamClientV2(DbxRequestConfig requestConfig, String accessToken) {
        this(requestConfig, accessToken, DbxHost.DEFAULT);
    }

    public DbxTeamClientV2(DbxRequestConfig requestConfig, String accessToken, DbxHost host) {
        this(new DbxRawClientV2(requestConfig, accessToken, host));
    }

    DbxTeamClientV2(DbxRawClientV2 _client) {
        this._client = _client;
        this.team = new DbxTeamTeamRequests(_client);
    }

    public DbxTeamTeamRequests team() {
        return this.team;
    }

    public DbxClientV2 asMember(String memberId) {
        if (memberId == null) {
            throw new IllegalArgumentException("'memberId' should not be null");
        }
        return new DbxClientV2(new DbxTeamRawClientV2(this._client, memberId));
    }

    private static final class DbxTeamRawClientV2
    extends DbxRawClientV2 {
        private final String memberId;

        private DbxTeamRawClientV2(DbxRawClientV2 underlying, String memberId) {
            super(underlying);
            this.memberId = memberId;
        }

        @Override
        protected void addAuthHeaders(List<HttpRequestor.Header> headers) {
            super.addAuthHeaders(headers);
            DbxRequestUtil.addSelectUserHeader(headers, this.memberId);
        }
    }
}

