/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.files.WriteMode;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.regex.Pattern;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class CommitInfo {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String path;
    protected final WriteMode mode;
    protected final boolean autorename;
    protected final Date clientModified;
    protected final boolean mute;

    public CommitInfo(String path, WriteMode mode, boolean autorename, Date clientModified, boolean mute) {
        if (path == null) {
            throw new IllegalArgumentException("Required value for 'path' is null");
        }
        if (!Pattern.matches("/.*", path)) {
            throw new IllegalArgumentException("String 'path' does not match pattern");
        }
        this.path = path;
        if (mode == null) {
            throw new IllegalArgumentException("Required value for 'mode' is null");
        }
        this.mode = mode;
        this.autorename = autorename;
        this.clientModified = clientModified;
        this.mute = mute;
    }

    public CommitInfo(String path) {
        this(path, WriteMode.ADD, false, null, false);
    }

    public String getPath() {
        return this.path;
    }

    public WriteMode getMode() {
        return this.mode;
    }

    public boolean getAutorename() {
        return this.autorename;
    }

    public Date getClientModified() {
        return this.clientModified;
    }

    public boolean getMute() {
        return this.mute;
    }

    public static Builder newBuilder(String path) {
        return new Builder(path);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.path, this.mode, this.autorename, this.clientModified, this.mute});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            CommitInfo other = (CommitInfo)obj;
            return !(this.path != other.path && !this.path.equals(other.path) || this.mode != other.mode && !this.mode.equals(other.mode) || this.autorename != other.autorename || this.clientModified != other.clientModified && (this.clientModified == null || !this.clientModified.equals(other.clientModified)) || this.mute != other.mute);
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<CommitInfo> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(CommitInfo.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(CommitInfo.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<CommitInfo> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public CommitInfo deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String path = null;
            WriteMode mode = null;
            Boolean autorename = null;
            Date clientModified = null;
            Boolean mute = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("path".equals(_field)) {
                    path = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("mode".equals(_field)) {
                    mode = _p.readValueAs(WriteMode.class);
                    _p.nextToken();
                    continue;
                }
                if ("autorename".equals(_field)) {
                    autorename = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("client_modified".equals(_field)) {
                    clientModified = _ctx.parseDate(Deserializer.getStringValue(_p));
                    _p.nextToken();
                    continue;
                }
                if ("mute".equals(_field)) {
                    mute = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (path == null) {
                throw new JsonParseException(_p, "Required field \"path\" is missing.");
            }
            return new CommitInfo(path, mode, autorename, clientModified, mute);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<CommitInfo> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(CommitInfo.class);
        }

        public Serializer(boolean unwrapping) {
            super(CommitInfo.class, unwrapping);
        }

        @Override
        protected JsonSerializer<CommitInfo> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(CommitInfo value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("path", value.path);
            g.writeObjectField("mode", value.mode);
            g.writeObjectField("autorename", value.autorename);
            if (value.clientModified != null) {
                g.writeObjectField("client_modified", value.clientModified);
            }
            g.writeObjectField("mute", value.mute);
        }
    }

    public static class Builder {
        protected final String path;
        protected WriteMode mode;
        protected boolean autorename;
        protected Date clientModified;
        protected boolean mute;

        protected Builder(String path) {
            if (path == null) {
                throw new IllegalArgumentException("Required value for 'path' is null");
            }
            if (!Pattern.matches("/.*", path)) {
                throw new IllegalArgumentException("String 'path' does not match pattern");
            }
            this.path = path;
            this.mode = WriteMode.ADD;
            this.autorename = false;
            this.clientModified = null;
            this.mute = false;
        }

        public Builder withMode(WriteMode mode) {
            this.mode = mode != null ? mode : WriteMode.ADD;
            return this;
        }

        public Builder withAutorename(Boolean autorename) {
            this.autorename = autorename != null ? autorename : false;
            return this;
        }

        public Builder withClientModified(Date clientModified) {
            this.clientModified = clientModified;
            return this;
        }

        public Builder withMute(Boolean mute) {
            this.mute = mute != null ? mute : false;
            return this;
        }

        public CommitInfo build() {
            return new CommitInfo(this.path, this.mode, this.autorename, this.clientModified, this.mute);
        }
    }
}

