/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.files.SharingInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class FileSharingInfo
extends SharingInfo {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String parentSharedFolderId;
    protected final String modifiedBy;

    public FileSharingInfo(boolean readOnly, String parentSharedFolderId, String modifiedBy) {
        super(readOnly);
        if (parentSharedFolderId == null) {
            throw new IllegalArgumentException("Required value for 'parentSharedFolderId' is null");
        }
        if (!Pattern.matches("[-_0-9a-zA-Z:]+", parentSharedFolderId)) {
            throw new IllegalArgumentException("String 'parentSharedFolderId' does not match pattern");
        }
        this.parentSharedFolderId = parentSharedFolderId;
        if (modifiedBy != null) {
            if (modifiedBy.length() < 40) {
                throw new IllegalArgumentException("String 'modifiedBy' is shorter than 40");
            }
            if (modifiedBy.length() > 40) {
                throw new IllegalArgumentException("String 'modifiedBy' is longer than 40");
            }
        }
        this.modifiedBy = modifiedBy;
    }

    public FileSharingInfo(boolean readOnly, String parentSharedFolderId) {
        this(readOnly, parentSharedFolderId, null);
    }

    public String getParentSharedFolderId() {
        return this.parentSharedFolderId;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.parentSharedFolderId, this.modifiedBy});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            FileSharingInfo other = (FileSharingInfo)obj;
            return this.readOnly == other.readOnly && (this.parentSharedFolderId == other.parentSharedFolderId || this.parentSharedFolderId.equals(other.parentSharedFolderId)) && (this.modifiedBy == other.modifiedBy || this.modifiedBy != null && this.modifiedBy.equals(other.modifiedBy));
        }
        return false;
    }

    @Override
    public String toString() {
        return this.serialize(false);
    }

    @Override
    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<FileSharingInfo> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(FileSharingInfo.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(FileSharingInfo.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<FileSharingInfo> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public FileSharingInfo deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            Boolean readOnly = null;
            String parentSharedFolderId = null;
            String modifiedBy = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("read_only".equals(_field)) {
                    readOnly = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("parent_shared_folder_id".equals(_field)) {
                    parentSharedFolderId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("modified_by".equals(_field)) {
                    modifiedBy = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (readOnly == null) {
                throw new JsonParseException(_p, "Required field \"read_only\" is missing.");
            }
            if (parentSharedFolderId == null) {
                throw new JsonParseException(_p, "Required field \"parent_shared_folder_id\" is missing.");
            }
            return new FileSharingInfo(readOnly, parentSharedFolderId, modifiedBy);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<FileSharingInfo> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(FileSharingInfo.class);
        }

        public Serializer(boolean unwrapping) {
            super(FileSharingInfo.class, unwrapping);
        }

        @Override
        protected JsonSerializer<FileSharingInfo> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(FileSharingInfo value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("read_only", value.readOnly);
            g.writeObjectField("parent_shared_folder_id", value.parentSharedFolderId);
            if (value.modifiedBy != null) {
                g.writeObjectField("modified_by", value.modifiedBy);
            }
        }
    }
}

