/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.dropbox.core.v2.files.MediaMetadata;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class MediaInfo {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    public static final MediaInfo PENDING = new MediaInfo(Tag.PENDING, null);
    private final Tag tag;
    private final MediaMetadata metadataValue;

    private MediaInfo(Tag tag, MediaMetadata metadataValue) {
        this.tag = tag;
        this.metadataValue = metadataValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isPending() {
        return this.tag == Tag.PENDING;
    }

    public boolean isMetadata() {
        return this.tag == Tag.METADATA;
    }

    public static MediaInfo metadata(MediaMetadata value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new MediaInfo(Tag.METADATA, value);
    }

    public MediaMetadata getMetadataValue() {
        if (this.tag != Tag.METADATA) {
            throw new IllegalStateException("Invalid tag: required Tag.METADATA, but was Tag." + this.tag.name());
        }
        return this.metadataValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.metadataValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MediaInfo) {
            MediaInfo other = (MediaInfo)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case PENDING: {
                    return true;
                }
                case METADATA: {
                    return this.metadataValue == other.metadataValue || this.metadataValue.equals(other.metadataValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<MediaInfo, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(MediaInfo.class, Deserializer.getTagMapping(), null, new Class[0]);
        }

        @Override
        public MediaInfo deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case PENDING: {
                    return PENDING;
                }
                case METADATA: {
                    MediaMetadata value = null;
                    Deserializer.expectField(_p, "metadata");
                    value = _p.readValueAs(MediaMetadata.class);
                    _p.nextToken();
                    return MediaInfo.metadata(value);
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("pending", Tag.PENDING);
            values.put("metadata", Tag.METADATA);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<MediaInfo> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(MediaInfo.class, new Class[0]);
        }

        @Override
        public void serialize(MediaInfo value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case PENDING: {
                    g.writeString("pending");
                    break;
                }
                case METADATA: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "metadata");
                    g.writeObjectField("metadata", value.metadataValue);
                    g.writeEndObject();
                }
            }
        }
    }

    public static enum Tag {
        PENDING,
        METADATA;

    }
}

