/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
class RelocationArg {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String fromPath;
    protected final String toPath;

    public RelocationArg(String fromPath, String toPath) {
        if (fromPath == null) {
            throw new IllegalArgumentException("Required value for 'fromPath' is null");
        }
        if (!Pattern.matches("/.*", fromPath)) {
            throw new IllegalArgumentException("String 'fromPath' does not match pattern");
        }
        this.fromPath = fromPath;
        if (toPath == null) {
            throw new IllegalArgumentException("Required value for 'toPath' is null");
        }
        if (!Pattern.matches("/.*", toPath)) {
            throw new IllegalArgumentException("String 'toPath' does not match pattern");
        }
        this.toPath = toPath;
    }

    public String getFromPath() {
        return this.fromPath;
    }

    public String getToPath() {
        return this.toPath;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.fromPath, this.toPath});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            RelocationArg other = (RelocationArg)obj;
            return !(this.fromPath != other.fromPath && !this.fromPath.equals(other.fromPath) || this.toPath != other.toPath && !this.toPath.equals(other.toPath));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<RelocationArg> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(RelocationArg.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(RelocationArg.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<RelocationArg> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public RelocationArg deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String fromPath = null;
            String toPath = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("from_path".equals(_field)) {
                    fromPath = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("to_path".equals(_field)) {
                    toPath = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (fromPath == null) {
                throw new JsonParseException(_p, "Required field \"from_path\" is missing.");
            }
            if (toPath == null) {
                throw new JsonParseException(_p, "Required field \"to_path\" is missing.");
            }
            return new RelocationArg(fromPath, toPath);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<RelocationArg> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(RelocationArg.class);
        }

        public Serializer(boolean unwrapping) {
            super(RelocationArg.class, unwrapping);
        }

        @Override
        protected JsonSerializer<RelocationArg> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(RelocationArg value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("from_path", value.fromPath);
            g.writeObjectField("to_path", value.toPath);
        }
    }
}

