/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.dropbox.core.v2.files.LookupError;
import com.dropbox.core.v2.files.WriteError;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class RelocationError {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    public static final RelocationError CANT_COPY_SHARED_FOLDER = new RelocationError(Tag.CANT_COPY_SHARED_FOLDER, null, null, null);
    public static final RelocationError CANT_NEST_SHARED_FOLDER = new RelocationError(Tag.CANT_NEST_SHARED_FOLDER, null, null, null);
    public static final RelocationError CANT_MOVE_FOLDER_INTO_ITSELF = new RelocationError(Tag.CANT_MOVE_FOLDER_INTO_ITSELF, null, null, null);
    public static final RelocationError TOO_MANY_FILES = new RelocationError(Tag.TOO_MANY_FILES, null, null, null);
    public static final RelocationError OTHER = new RelocationError(Tag.OTHER, null, null, null);
    private final Tag tag;
    private final LookupError fromLookupValue;
    private final WriteError fromWriteValue;
    private final WriteError toValue;

    private RelocationError(Tag tag, LookupError fromLookupValue, WriteError fromWriteValue, WriteError toValue) {
        this.tag = tag;
        this.fromLookupValue = fromLookupValue;
        this.fromWriteValue = fromWriteValue;
        this.toValue = toValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isFromLookup() {
        return this.tag == Tag.FROM_LOOKUP;
    }

    public static RelocationError fromLookup(LookupError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new RelocationError(Tag.FROM_LOOKUP, value, null, null);
    }

    public LookupError getFromLookupValue() {
        if (this.tag != Tag.FROM_LOOKUP) {
            throw new IllegalStateException("Invalid tag: required Tag.FROM_LOOKUP, but was Tag." + this.tag.name());
        }
        return this.fromLookupValue;
    }

    public boolean isFromWrite() {
        return this.tag == Tag.FROM_WRITE;
    }

    public static RelocationError fromWrite(WriteError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new RelocationError(Tag.FROM_WRITE, null, value, null);
    }

    public WriteError getFromWriteValue() {
        if (this.tag != Tag.FROM_WRITE) {
            throw new IllegalStateException("Invalid tag: required Tag.FROM_WRITE, but was Tag." + this.tag.name());
        }
        return this.fromWriteValue;
    }

    public boolean isTo() {
        return this.tag == Tag.TO;
    }

    public static RelocationError to(WriteError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new RelocationError(Tag.TO, null, null, value);
    }

    public WriteError getToValue() {
        if (this.tag != Tag.TO) {
            throw new IllegalStateException("Invalid tag: required Tag.TO, but was Tag." + this.tag.name());
        }
        return this.toValue;
    }

    public boolean isCantCopySharedFolder() {
        return this.tag == Tag.CANT_COPY_SHARED_FOLDER;
    }

    public boolean isCantNestSharedFolder() {
        return this.tag == Tag.CANT_NEST_SHARED_FOLDER;
    }

    public boolean isCantMoveFolderIntoItself() {
        return this.tag == Tag.CANT_MOVE_FOLDER_INTO_ITSELF;
    }

    public boolean isTooManyFiles() {
        return this.tag == Tag.TOO_MANY_FILES;
    }

    public boolean isOther() {
        return this.tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.fromLookupValue, this.fromWriteValue, this.toValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RelocationError) {
            RelocationError other = (RelocationError)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case FROM_LOOKUP: {
                    return this.fromLookupValue == other.fromLookupValue || this.fromLookupValue.equals(other.fromLookupValue);
                }
                case FROM_WRITE: {
                    return this.fromWriteValue == other.fromWriteValue || this.fromWriteValue.equals(other.fromWriteValue);
                }
                case TO: {
                    return this.toValue == other.toValue || this.toValue.equals(other.toValue);
                }
                case CANT_COPY_SHARED_FOLDER: {
                    return true;
                }
                case CANT_NEST_SHARED_FOLDER: {
                    return true;
                }
                case CANT_MOVE_FOLDER_INTO_ITSELF: {
                    return true;
                }
                case TOO_MANY_FILES: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<RelocationError, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(RelocationError.class, Deserializer.getTagMapping(), Tag.OTHER, new Class[0]);
        }

        @Override
        public RelocationError deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case FROM_LOOKUP: {
                    LookupError value = null;
                    Deserializer.expectField(_p, "from_lookup");
                    value = _p.readValueAs(LookupError.class);
                    _p.nextToken();
                    return RelocationError.fromLookup(value);
                }
                case FROM_WRITE: {
                    WriteError value = null;
                    Deserializer.expectField(_p, "from_write");
                    value = _p.readValueAs(WriteError.class);
                    _p.nextToken();
                    return RelocationError.fromWrite(value);
                }
                case TO: {
                    WriteError value = null;
                    Deserializer.expectField(_p, "to");
                    value = _p.readValueAs(WriteError.class);
                    _p.nextToken();
                    return RelocationError.to(value);
                }
                case CANT_COPY_SHARED_FOLDER: {
                    return CANT_COPY_SHARED_FOLDER;
                }
                case CANT_NEST_SHARED_FOLDER: {
                    return CANT_NEST_SHARED_FOLDER;
                }
                case CANT_MOVE_FOLDER_INTO_ITSELF: {
                    return CANT_MOVE_FOLDER_INTO_ITSELF;
                }
                case TOO_MANY_FILES: {
                    return TOO_MANY_FILES;
                }
                case OTHER: {
                    return OTHER;
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("from_lookup", Tag.FROM_LOOKUP);
            values.put("from_write", Tag.FROM_WRITE);
            values.put("to", Tag.TO);
            values.put("cant_copy_shared_folder", Tag.CANT_COPY_SHARED_FOLDER);
            values.put("cant_nest_shared_folder", Tag.CANT_NEST_SHARED_FOLDER);
            values.put("cant_move_folder_into_itself", Tag.CANT_MOVE_FOLDER_INTO_ITSELF);
            values.put("too_many_files", Tag.TOO_MANY_FILES);
            values.put("other", Tag.OTHER);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<RelocationError> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(RelocationError.class, new Class[0]);
        }

        @Override
        public void serialize(RelocationError value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case FROM_LOOKUP: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "from_lookup");
                    g.writeObjectField("from_lookup", value.fromLookupValue);
                    g.writeEndObject();
                    break;
                }
                case FROM_WRITE: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "from_write");
                    g.writeObjectField("from_write", value.fromWriteValue);
                    g.writeEndObject();
                    break;
                }
                case TO: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "to");
                    g.writeObjectField("to", value.toValue);
                    g.writeEndObject();
                    break;
                }
                case CANT_COPY_SHARED_FOLDER: {
                    g.writeString("cant_copy_shared_folder");
                    break;
                }
                case CANT_NEST_SHARED_FOLDER: {
                    g.writeString("cant_nest_shared_folder");
                    break;
                }
                case CANT_MOVE_FOLDER_INTO_ITSELF: {
                    g.writeString("cant_move_folder_into_itself");
                    break;
                }
                case TOO_MANY_FILES: {
                    g.writeString("too_many_files");
                    break;
                }
                case OTHER: {
                    g.writeString("other");
                }
            }
        }
    }

    public static enum Tag {
        FROM_LOOKUP,
        FROM_WRITE,
        TO,
        CANT_COPY_SHARED_FOLDER,
        CANT_NEST_SHARED_FOLDER,
        CANT_MOVE_FOLDER_INTO_ITSELF,
        TOO_MANY_FILES,
        OTHER;

    }
}

