/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.files.ThumbnailFormat;
import com.dropbox.core.v2.files.ThumbnailSize;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
class ThumbnailArg {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String path;
    protected final ThumbnailFormat format;
    protected final ThumbnailSize size;

    public ThumbnailArg(String path, ThumbnailFormat format, ThumbnailSize size) {
        if (path == null) {
            throw new IllegalArgumentException("Required value for 'path' is null");
        }
        if (!Pattern.matches("((/|id:).*)|(rev:[0-9a-f]{9,})", path)) {
            throw new IllegalArgumentException("String 'path' does not match pattern");
        }
        this.path = path;
        if (format == null) {
            throw new IllegalArgumentException("Required value for 'format' is null");
        }
        this.format = format;
        if (size == null) {
            throw new IllegalArgumentException("Required value for 'size' is null");
        }
        this.size = size;
    }

    public ThumbnailArg(String path) {
        this(path, ThumbnailFormat.JPEG, ThumbnailSize.W64H64);
    }

    public String getPath() {
        return this.path;
    }

    public ThumbnailFormat getFormat() {
        return this.format;
    }

    public ThumbnailSize getSize() {
        return this.size;
    }

    public static Builder newBuilder(String path) {
        return new Builder(path);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.path, this.format, this.size});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            ThumbnailArg other = (ThumbnailArg)obj;
            return !(this.path != other.path && !this.path.equals(other.path) || this.format != other.format && !this.format.equals((Object)other.format) || this.size != other.size && !this.size.equals((Object)other.size));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<ThumbnailArg> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(ThumbnailArg.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(ThumbnailArg.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<ThumbnailArg> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public ThumbnailArg deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String path = null;
            ThumbnailFormat format = null;
            ThumbnailSize size = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("path".equals(_field)) {
                    path = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("format".equals(_field)) {
                    format = _p.readValueAs(ThumbnailFormat.class);
                    _p.nextToken();
                    continue;
                }
                if ("size".equals(_field)) {
                    size = _p.readValueAs(ThumbnailSize.class);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (path == null) {
                throw new JsonParseException(_p, "Required field \"path\" is missing.");
            }
            return new ThumbnailArg(path, format, size);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<ThumbnailArg> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(ThumbnailArg.class);
        }

        public Serializer(boolean unwrapping) {
            super(ThumbnailArg.class, unwrapping);
        }

        @Override
        protected JsonSerializer<ThumbnailArg> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(ThumbnailArg value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("path", value.path);
            g.writeObjectField("format", (Object)value.format);
            g.writeObjectField("size", (Object)value.size);
        }
    }

    public static class Builder {
        protected final String path;
        protected ThumbnailFormat format;
        protected ThumbnailSize size;

        protected Builder(String path) {
            if (path == null) {
                throw new IllegalArgumentException("Required value for 'path' is null");
            }
            if (!Pattern.matches("((/|id:).*)|(rev:[0-9a-f]{9,})", path)) {
                throw new IllegalArgumentException("String 'path' does not match pattern");
            }
            this.path = path;
            this.format = ThumbnailFormat.JPEG;
            this.size = ThumbnailSize.W64H64;
        }

        public Builder withFormat(ThumbnailFormat format) {
            this.format = format != null ? format : ThumbnailFormat.JPEG;
            return this;
        }

        public Builder withSize(ThumbnailSize size) {
            this.size = size != null ? size : ThumbnailSize.W64H64;
            return this;
        }

        public ThumbnailArg build() {
            return new ThumbnailArg(this.path, this.format, this.size);
        }
    }
}

