/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxUploadStyleBuilder;
import com.dropbox.core.v2.files.CommitInfo;
import com.dropbox.core.v2.files.DbxUserFilesRequests;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.UploadError;
import com.dropbox.core.v2.files.UploadErrorException;
import com.dropbox.core.v2.files.UploadUploader;
import com.dropbox.core.v2.files.WriteMode;
import java.util.Date;

public class UploadBuilder
extends DbxUploadStyleBuilder<FileMetadata, UploadError, UploadErrorException> {
    private final DbxUserFilesRequests files;
    private final CommitInfo.Builder commitInfoBuilder;

    UploadBuilder(DbxUserFilesRequests files, CommitInfo.Builder commitInfoBuilder) {
        if (files == null) {
            throw new NullPointerException("files");
        }
        if (commitInfoBuilder == null) {
            throw new NullPointerException("commitInfoBuilder");
        }
        this.files = files;
        this.commitInfoBuilder = commitInfoBuilder;
    }

    public UploadBuilder withMode(WriteMode mode) {
        this.commitInfoBuilder.withMode(mode);
        return this;
    }

    public UploadBuilder withAutorename(Boolean autorename) {
        this.commitInfoBuilder.withAutorename(autorename);
        return this;
    }

    public UploadBuilder withClientModified(Date clientModified) {
        this.commitInfoBuilder.withClientModified(clientModified);
        return this;
    }

    public UploadBuilder withMute(Boolean mute) {
        this.commitInfoBuilder.withMute(mute);
        return this;
    }

    public UploadUploader start() throws UploadErrorException, DbxException {
        CommitInfo arg = this.commitInfoBuilder.build();
        return this.files.upload(arg);
    }
}

