/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class WriteMode {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    public static final WriteMode ADD = new WriteMode(Tag.ADD, null);
    public static final WriteMode OVERWRITE = new WriteMode(Tag.OVERWRITE, null);
    private final Tag tag;
    private final String updateValue;

    private WriteMode(Tag tag, String updateValue) {
        this.tag = tag;
        this.updateValue = updateValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isAdd() {
        return this.tag == Tag.ADD;
    }

    public boolean isOverwrite() {
        return this.tag == Tag.OVERWRITE;
    }

    public boolean isUpdate() {
        return this.tag == Tag.UPDATE;
    }

    public static WriteMode update(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() < 9) {
            throw new IllegalArgumentException("String is shorter than 9");
        }
        if (!Pattern.matches("[0-9a-f]+", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new WriteMode(Tag.UPDATE, value);
    }

    public String getUpdateValue() {
        if (this.tag != Tag.UPDATE) {
            throw new IllegalStateException("Invalid tag: required Tag.UPDATE, but was Tag." + this.tag.name());
        }
        return this.updateValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.updateValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof WriteMode) {
            WriteMode other = (WriteMode)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case ADD: {
                    return true;
                }
                case OVERWRITE: {
                    return true;
                }
                case UPDATE: {
                    return this.updateValue == other.updateValue || this.updateValue.equals(other.updateValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<WriteMode, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(WriteMode.class, Deserializer.getTagMapping(), null, new Class[0]);
        }

        @Override
        public WriteMode deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case ADD: {
                    return ADD;
                }
                case OVERWRITE: {
                    return OVERWRITE;
                }
                case UPDATE: {
                    String value = null;
                    Deserializer.expectField(_p, "update");
                    value = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    return WriteMode.update(value);
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("add", Tag.ADD);
            values.put("overwrite", Tag.OVERWRITE);
            values.put("update", Tag.UPDATE);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<WriteMode> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(WriteMode.class, new Class[0]);
        }

        @Override
        public void serialize(WriteMode value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case ADD: {
                    g.writeString("add");
                    break;
                }
                case OVERWRITE: {
                    g.writeString("overwrite");
                    break;
                }
                case UPDATE: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "update");
                    g.writeObjectField("update", value.updateValue);
                    g.writeEndObject();
                }
            }
        }
    }

    public static enum Tag {
        ADD,
        OVERWRITE,
        UPDATE;

    }
}

