/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.sharing.AddMember;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
class AddFolderMemberArg {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String sharedFolderId;
    protected final List<AddMember> members;
    protected final boolean quiet;
    protected final String customMessage;

    public AddFolderMemberArg(String sharedFolderId, List<AddMember> members, boolean quiet, String customMessage) {
        if (sharedFolderId == null) {
            throw new IllegalArgumentException("Required value for 'sharedFolderId' is null");
        }
        if (!Pattern.matches("[-_0-9a-zA-Z:]+", sharedFolderId)) {
            throw new IllegalArgumentException("String 'sharedFolderId' does not match pattern");
        }
        this.sharedFolderId = sharedFolderId;
        if (members == null) {
            throw new IllegalArgumentException("Required value for 'members' is null");
        }
        for (AddMember x : members) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'members' is null");
        }
        this.members = members;
        this.quiet = quiet;
        if (customMessage != null && customMessage.length() < 1) {
            throw new IllegalArgumentException("String 'customMessage' is shorter than 1");
        }
        this.customMessage = customMessage;
    }

    public AddFolderMemberArg(String sharedFolderId, List<AddMember> members) {
        this(sharedFolderId, members, false, null);
    }

    public String getSharedFolderId() {
        return this.sharedFolderId;
    }

    public List<AddMember> getMembers() {
        return this.members;
    }

    public boolean getQuiet() {
        return this.quiet;
    }

    public String getCustomMessage() {
        return this.customMessage;
    }

    public static Builder newBuilder(String sharedFolderId, List<AddMember> members) {
        return new Builder(sharedFolderId, members);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.sharedFolderId, this.members, this.quiet, this.customMessage});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            AddFolderMemberArg other = (AddFolderMemberArg)obj;
            return !(this.sharedFolderId != other.sharedFolderId && !this.sharedFolderId.equals(other.sharedFolderId) || this.members != other.members && !this.members.equals(other.members) || this.quiet != other.quiet || this.customMessage != other.customMessage && (this.customMessage == null || !this.customMessage.equals(other.customMessage)));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<AddFolderMemberArg> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(AddFolderMemberArg.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(AddFolderMemberArg.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<AddFolderMemberArg> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public AddFolderMemberArg deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String sharedFolderId = null;
            ArrayList<AddMember> members = null;
            Boolean quiet = null;
            String customMessage = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("shared_folder_id".equals(_field)) {
                    sharedFolderId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("members".equals(_field)) {
                    Deserializer.expectArrayStart(_p);
                    members = new ArrayList<AddMember>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        AddMember _x = null;
                        _x = _p.readValueAs(AddMember.class);
                        _p.nextToken();
                        members.add(_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    continue;
                }
                if ("quiet".equals(_field)) {
                    quiet = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("custom_message".equals(_field)) {
                    customMessage = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (sharedFolderId == null) {
                throw new JsonParseException(_p, "Required field \"shared_folder_id\" is missing.");
            }
            if (members == null) {
                throw new JsonParseException(_p, "Required field \"members\" is missing.");
            }
            return new AddFolderMemberArg(sharedFolderId, members, quiet, customMessage);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<AddFolderMemberArg> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(AddFolderMemberArg.class);
        }

        public Serializer(boolean unwrapping) {
            super(AddFolderMemberArg.class, unwrapping);
        }

        @Override
        protected JsonSerializer<AddFolderMemberArg> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(AddFolderMemberArg value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("shared_folder_id", value.sharedFolderId);
            g.writeObjectField("members", value.members);
            g.writeObjectField("quiet", value.quiet);
            if (value.customMessage != null) {
                g.writeObjectField("custom_message", value.customMessage);
            }
        }
    }

    public static class Builder {
        protected final String sharedFolderId;
        protected final List<AddMember> members;
        protected boolean quiet;
        protected String customMessage;

        protected Builder(String sharedFolderId, List<AddMember> members) {
            if (sharedFolderId == null) {
                throw new IllegalArgumentException("Required value for 'sharedFolderId' is null");
            }
            if (!Pattern.matches("[-_0-9a-zA-Z:]+", sharedFolderId)) {
                throw new IllegalArgumentException("String 'sharedFolderId' does not match pattern");
            }
            this.sharedFolderId = sharedFolderId;
            if (members == null) {
                throw new IllegalArgumentException("Required value for 'members' is null");
            }
            for (AddMember x : members) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'members' is null");
            }
            this.members = members;
            this.quiet = false;
            this.customMessage = null;
        }

        public Builder withQuiet(Boolean quiet) {
            this.quiet = quiet != null ? quiet : false;
            return this;
        }

        public Builder withCustomMessage(String customMessage) {
            if (customMessage != null && customMessage.length() < 1) {
                throw new IllegalArgumentException("String 'customMessage' is shorter than 1");
            }
            this.customMessage = customMessage;
            return this;
        }

        public AddFolderMemberArg build() {
            return new AddFolderMemberArg(this.sharedFolderId, this.members, this.quiet, this.customMessage);
        }
    }
}

