/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.sharing.FolderAction;
import com.dropbox.core.v2.sharing.PermissionDeniedReason;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class FolderPermission {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final FolderAction action;
    protected final boolean allow;
    protected final PermissionDeniedReason reason;

    public FolderPermission(FolderAction action, boolean allow, PermissionDeniedReason reason) {
        if (action == null) {
            throw new IllegalArgumentException("Required value for 'action' is null");
        }
        this.action = action;
        this.allow = allow;
        this.reason = reason;
    }

    public FolderPermission(FolderAction action, boolean allow) {
        this(action, allow, null);
    }

    public FolderAction getAction() {
        return this.action;
    }

    public boolean getAllow() {
        return this.allow;
    }

    public PermissionDeniedReason getReason() {
        return this.reason;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.action, this.allow, this.reason});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            FolderPermission other = (FolderPermission)obj;
            return (this.action == other.action || this.action.equals((Object)other.action)) && this.allow == other.allow && (this.reason == other.reason || this.reason != null && this.reason.equals((Object)other.reason));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<FolderPermission> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(FolderPermission.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(FolderPermission.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<FolderPermission> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public FolderPermission deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            FolderAction action = null;
            Boolean allow = null;
            PermissionDeniedReason reason = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("action".equals(_field)) {
                    action = _p.readValueAs(FolderAction.class);
                    _p.nextToken();
                    continue;
                }
                if ("allow".equals(_field)) {
                    allow = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("reason".equals(_field)) {
                    reason = _p.readValueAs(PermissionDeniedReason.class);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (action == null) {
                throw new JsonParseException(_p, "Required field \"action\" is missing.");
            }
            if (allow == null) {
                throw new JsonParseException(_p, "Required field \"allow\" is missing.");
            }
            return new FolderPermission(action, allow, reason);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<FolderPermission> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(FolderPermission.class);
        }

        public Serializer(boolean unwrapping) {
            super(FolderPermission.class, unwrapping);
        }

        @Override
        protected JsonSerializer<FolderPermission> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(FolderPermission value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("action", (Object)value.action);
            g.writeObjectField("allow", value.allow);
            if (value.reason != null) {
                g.writeObjectField("reason", (Object)value.reason);
            }
        }
    }
}

