/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class InviteeInfo {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    public static final InviteeInfo OTHER = new InviteeInfo(Tag.OTHER, null);
    private final Tag tag;
    private final String emailValue;

    private InviteeInfo(Tag tag, String emailValue) {
        this.tag = tag;
        this.emailValue = emailValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isEmail() {
        return this.tag == Tag.EMAIL;
    }

    public static InviteeInfo email(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 255) {
            throw new IllegalArgumentException("String is longer than 255");
        }
        if (!Pattern.matches("^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*.[A-Za-z]{2,15}$", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new InviteeInfo(Tag.EMAIL, value);
    }

    public String getEmailValue() {
        if (this.tag != Tag.EMAIL) {
            throw new IllegalStateException("Invalid tag: required Tag.EMAIL, but was Tag." + this.tag.name());
        }
        return this.emailValue;
    }

    public boolean isOther() {
        return this.tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.emailValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof InviteeInfo) {
            InviteeInfo other = (InviteeInfo)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case EMAIL: {
                    return this.emailValue == other.emailValue || this.emailValue.equals(other.emailValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<InviteeInfo, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(InviteeInfo.class, Deserializer.getTagMapping(), Tag.OTHER, new Class[0]);
        }

        @Override
        public InviteeInfo deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case EMAIL: {
                    String value = null;
                    Deserializer.expectField(_p, "email");
                    value = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    return InviteeInfo.email(value);
                }
                case OTHER: {
                    return OTHER;
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("email", Tag.EMAIL);
            values.put("other", Tag.OTHER);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<InviteeInfo> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(InviteeInfo.class, new Class[0]);
        }

        @Override
        public void serialize(InviteeInfo value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case EMAIL: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "email");
                    g.writeObjectField("email", value.emailValue);
                    g.writeEndObject();
                    break;
                }
                case OTHER: {
                    g.writeString("other");
                }
            }
        }
    }

    public static enum Tag {
        EMAIL,
        OTHER;

    }
}

