/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.dropbox.core.v2.sharing.RemoveFolderMemberError;
import com.dropbox.core.v2.sharing.UnshareFolderError;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class JobError {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    public static final JobError OTHER = new JobError(Tag.OTHER, null, null);
    private final Tag tag;
    private final UnshareFolderError unshareFolderErrorValue;
    private final RemoveFolderMemberError removeFolderMemberErrorValue;

    private JobError(Tag tag, UnshareFolderError unshareFolderErrorValue, RemoveFolderMemberError removeFolderMemberErrorValue) {
        this.tag = tag;
        this.unshareFolderErrorValue = unshareFolderErrorValue;
        this.removeFolderMemberErrorValue = removeFolderMemberErrorValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isUnshareFolderError() {
        return this.tag == Tag.UNSHARE_FOLDER_ERROR;
    }

    public static JobError unshareFolderError(UnshareFolderError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new JobError(Tag.UNSHARE_FOLDER_ERROR, value, null);
    }

    public UnshareFolderError getUnshareFolderErrorValue() {
        if (this.tag != Tag.UNSHARE_FOLDER_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.UNSHARE_FOLDER_ERROR, but was Tag." + this.tag.name());
        }
        return this.unshareFolderErrorValue;
    }

    public boolean isRemoveFolderMemberError() {
        return this.tag == Tag.REMOVE_FOLDER_MEMBER_ERROR;
    }

    public static JobError removeFolderMemberError(RemoveFolderMemberError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new JobError(Tag.REMOVE_FOLDER_MEMBER_ERROR, null, value);
    }

    public RemoveFolderMemberError getRemoveFolderMemberErrorValue() {
        if (this.tag != Tag.REMOVE_FOLDER_MEMBER_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.REMOVE_FOLDER_MEMBER_ERROR, but was Tag." + this.tag.name());
        }
        return this.removeFolderMemberErrorValue;
    }

    public boolean isOther() {
        return this.tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.unshareFolderErrorValue, this.removeFolderMemberErrorValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JobError) {
            JobError other = (JobError)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case UNSHARE_FOLDER_ERROR: {
                    return this.unshareFolderErrorValue == other.unshareFolderErrorValue || this.unshareFolderErrorValue.equals(other.unshareFolderErrorValue);
                }
                case REMOVE_FOLDER_MEMBER_ERROR: {
                    return this.removeFolderMemberErrorValue == other.removeFolderMemberErrorValue || this.removeFolderMemberErrorValue.equals(other.removeFolderMemberErrorValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<JobError, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(JobError.class, Deserializer.getTagMapping(), Tag.OTHER, new Class[0]);
        }

        @Override
        public JobError deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case UNSHARE_FOLDER_ERROR: {
                    UnshareFolderError value = null;
                    Deserializer.expectField(_p, "unshare_folder_error");
                    value = _p.readValueAs(UnshareFolderError.class);
                    _p.nextToken();
                    return JobError.unshareFolderError(value);
                }
                case REMOVE_FOLDER_MEMBER_ERROR: {
                    RemoveFolderMemberError value = null;
                    Deserializer.expectField(_p, "remove_folder_member_error");
                    value = _p.readValueAs(RemoveFolderMemberError.class);
                    _p.nextToken();
                    return JobError.removeFolderMemberError(value);
                }
                case OTHER: {
                    return OTHER;
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("unshare_folder_error", Tag.UNSHARE_FOLDER_ERROR);
            values.put("remove_folder_member_error", Tag.REMOVE_FOLDER_MEMBER_ERROR);
            values.put("other", Tag.OTHER);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<JobError> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(JobError.class, new Class[0]);
        }

        @Override
        public void serialize(JobError value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case UNSHARE_FOLDER_ERROR: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "unshare_folder_error");
                    g.writeObjectField("unshare_folder_error", value.unshareFolderErrorValue);
                    g.writeEndObject();
                    break;
                }
                case REMOVE_FOLDER_MEMBER_ERROR: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "remove_folder_member_error");
                    g.writeObjectField("remove_folder_member_error", value.removeFolderMemberErrorValue);
                    g.writeEndObject();
                    break;
                }
                case OTHER: {
                    g.writeString("other");
                }
            }
        }
    }

    public static enum Tag {
        UNSHARE_FOLDER_ERROR,
        REMOVE_FOLDER_MEMBER_ERROR,
        OTHER;

    }
}

