/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.dropbox.core.v2.sharing.JobError;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class JobStatus {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    public static final JobStatus IN_PROGRESS = new JobStatus(Tag.IN_PROGRESS, null);
    public static final JobStatus COMPLETE = new JobStatus(Tag.COMPLETE, null);
    private final Tag tag;
    private final JobError failedValue;

    private JobStatus(Tag tag, JobError failedValue) {
        this.tag = tag;
        this.failedValue = failedValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isInProgress() {
        return this.tag == Tag.IN_PROGRESS;
    }

    public boolean isComplete() {
        return this.tag == Tag.COMPLETE;
    }

    public boolean isFailed() {
        return this.tag == Tag.FAILED;
    }

    public static JobStatus failed(JobError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new JobStatus(Tag.FAILED, value);
    }

    public JobError getFailedValue() {
        if (this.tag != Tag.FAILED) {
            throw new IllegalStateException("Invalid tag: required Tag.FAILED, but was Tag." + this.tag.name());
        }
        return this.failedValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.failedValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JobStatus) {
            JobStatus other = (JobStatus)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case IN_PROGRESS: {
                    return true;
                }
                case COMPLETE: {
                    return true;
                }
                case FAILED: {
                    return this.failedValue == other.failedValue || this.failedValue.equals(other.failedValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<JobStatus, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(JobStatus.class, Deserializer.getTagMapping(), null, new Class[0]);
        }

        @Override
        public JobStatus deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case IN_PROGRESS: {
                    return IN_PROGRESS;
                }
                case COMPLETE: {
                    return COMPLETE;
                }
                case FAILED: {
                    JobError value = null;
                    Deserializer.expectField(_p, "failed");
                    value = _p.readValueAs(JobError.class);
                    _p.nextToken();
                    return JobStatus.failed(value);
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("complete", Tag.COMPLETE);
            values.put("failed", Tag.FAILED);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<JobStatus> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(JobStatus.class, new Class[0]);
        }

        @Override
        public void serialize(JobStatus value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case IN_PROGRESS: {
                    g.writeString("in_progress");
                    break;
                }
                case COMPLETE: {
                    g.writeString("complete");
                    break;
                }
                case FAILED: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "failed");
                    g.writeObjectField("failed", value.failedValue);
                    g.writeEndObject();
                }
            }
        }
    }

    public static enum Tag {
        IN_PROGRESS,
        COMPLETE,
        FAILED;

    }
}

