/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.sharing.FolderAction;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
class ListFoldersArgs {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final long limit;
    protected final List<FolderAction> actions;

    public ListFoldersArgs(long limit, List<FolderAction> actions) {
        if (limit < 1L) {
            throw new IllegalArgumentException("Number 'limit' is smaller than 1L");
        }
        if (limit > 1000L) {
            throw new IllegalArgumentException("Number 'limit' is larger than 1000L");
        }
        this.limit = limit;
        if (actions != null) {
            for (FolderAction x : actions) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'actions' is null");
            }
        }
        this.actions = actions;
    }

    public ListFoldersArgs() {
        this(1000L, null);
    }

    public long getLimit() {
        return this.limit;
    }

    public List<FolderAction> getActions() {
        return this.actions;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.limit, this.actions});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            ListFoldersArgs other = (ListFoldersArgs)obj;
            return this.limit == other.limit && (this.actions == other.actions || this.actions != null && this.actions.equals(other.actions));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<ListFoldersArgs> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(ListFoldersArgs.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(ListFoldersArgs.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<ListFoldersArgs> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public ListFoldersArgs deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            Long limit = null;
            ArrayList<FolderAction> actions = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("limit".equals(_field)) {
                    limit = _p.getLongValue();
                    Deserializer.assertUnsigned(_p, limit);
                    if (limit > Integer.MAX_VALUE) {
                        throw new JsonParseException(_p, "expecting a 32-bit unsigned integer, got: " + limit);
                    }
                    _p.nextToken();
                    continue;
                }
                if ("actions".equals(_field)) {
                    Deserializer.expectArrayStart(_p);
                    actions = new ArrayList<FolderAction>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        FolderAction _x = null;
                        _x = _p.readValueAs(FolderAction.class);
                        _p.nextToken();
                        actions.add(_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            return new ListFoldersArgs(limit, actions);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<ListFoldersArgs> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(ListFoldersArgs.class);
        }

        public Serializer(boolean unwrapping) {
            super(ListFoldersArgs.class, unwrapping);
        }

        @Override
        protected JsonSerializer<ListFoldersArgs> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(ListFoldersArgs value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("limit", value.limit);
            if (value.actions != null) {
                g.writeObjectField("actions", value.actions);
            }
        }
    }

    public static class Builder {
        protected long limit = 1000L;
        protected List<FolderAction> actions = null;

        protected Builder() {
        }

        public Builder withLimit(Long limit) {
            if (limit < 1L) {
                throw new IllegalArgumentException("Number 'limit' is smaller than 1L");
            }
            if (limit > 1000L) {
                throw new IllegalArgumentException("Number 'limit' is larger than 1000L");
            }
            this.limit = limit != null ? limit : 1000L;
            return this;
        }

        public Builder withActions(List<FolderAction> actions) {
            if (actions != null) {
                for (FolderAction x : actions) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'actions' is null");
                }
            }
            this.actions = actions;
            return this;
        }

        public ListFoldersArgs build() {
            return new ListFoldersArgs(this.limit, this.actions);
        }
    }
}

