/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.sharing.LinkMetadata;
import com.dropbox.core.v2.sharing.Visibility;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class PathLinkMetadata
extends LinkMetadata {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String path;

    public PathLinkMetadata(String url, Visibility visibility, String path, Date expires) {
        super(url, visibility, expires);
        if (path == null) {
            throw new IllegalArgumentException("Required value for 'path' is null");
        }
        this.path = path;
    }

    public PathLinkMetadata(String url, Visibility visibility, String path) {
        this(url, visibility, path, null);
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.path});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            PathLinkMetadata other = (PathLinkMetadata)obj;
            return !(this.url != other.url && !this.url.equals(other.url) || this.visibility != other.visibility && !this.visibility.equals((Object)other.visibility) || this.path != other.path && !this.path.equals(other.path) || this.expires != other.expires && (this.expires == null || !this.expires.equals(other.expires)));
        }
        return false;
    }

    @Override
    public String toString() {
        return this.serialize(false);
    }

    @Override
    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<PathLinkMetadata> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(PathLinkMetadata.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(PathLinkMetadata.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<PathLinkMetadata> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public PathLinkMetadata deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String _subtype_tag = Deserializer.readEnumeratedSubtypeTag(_p, "path");
            String url = null;
            Visibility visibility = null;
            String path = null;
            Date expires = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("url".equals(_field)) {
                    url = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("visibility".equals(_field)) {
                    visibility = _p.readValueAs(Visibility.class);
                    _p.nextToken();
                    continue;
                }
                if ("path".equals(_field)) {
                    path = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("expires".equals(_field)) {
                    expires = _ctx.parseDate(Deserializer.getStringValue(_p));
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (url == null) {
                throw new JsonParseException(_p, "Required field \"url\" is missing.");
            }
            if (visibility == null) {
                throw new JsonParseException(_p, "Required field \"visibility\" is missing.");
            }
            if (path == null) {
                throw new JsonParseException(_p, "Required field \"path\" is missing.");
            }
            return new PathLinkMetadata(url, visibility, path, expires);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<PathLinkMetadata> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(PathLinkMetadata.class);
        }

        public Serializer(boolean unwrapping) {
            super(PathLinkMetadata.class, unwrapping);
        }

        @Override
        protected void serializeFields(PathLinkMetadata value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeStringField(".tag", "path");
            g.writeObjectField("url", value.url);
            g.writeObjectField("visibility", (Object)value.visibility);
            g.writeObjectField("path", value.path);
            if (value.expires != null) {
                g.writeObjectField("expires", value.expires);
            }
        }
    }
}

