/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.dropbox.core.v2.sharing.SharedFolderMetadata;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class ShareFolderLaunch {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    private final Tag tag;
    private final String asyncJobIdValue;
    private final SharedFolderMetadata completeValue;

    private ShareFolderLaunch(Tag tag, String asyncJobIdValue, SharedFolderMetadata completeValue) {
        this.tag = tag;
        this.asyncJobIdValue = asyncJobIdValue;
        this.completeValue = completeValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isAsyncJobId() {
        return this.tag == Tag.ASYNC_JOB_ID;
    }

    public static ShareFolderLaunch asyncJobId(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() < 1) {
            throw new IllegalArgumentException("String is shorter than 1");
        }
        return new ShareFolderLaunch(Tag.ASYNC_JOB_ID, value, null);
    }

    public String getAsyncJobIdValue() {
        if (this.tag != Tag.ASYNC_JOB_ID) {
            throw new IllegalStateException("Invalid tag: required Tag.ASYNC_JOB_ID, but was Tag." + this.tag.name());
        }
        return this.asyncJobIdValue;
    }

    public boolean isComplete() {
        return this.tag == Tag.COMPLETE;
    }

    public static ShareFolderLaunch complete(SharedFolderMetadata value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new ShareFolderLaunch(Tag.COMPLETE, null, value);
    }

    public SharedFolderMetadata getCompleteValue() {
        if (this.tag != Tag.COMPLETE) {
            throw new IllegalStateException("Invalid tag: required Tag.COMPLETE, but was Tag." + this.tag.name());
        }
        return this.completeValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.asyncJobIdValue, this.completeValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ShareFolderLaunch) {
            ShareFolderLaunch other = (ShareFolderLaunch)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case ASYNC_JOB_ID: {
                    return this.asyncJobIdValue == other.asyncJobIdValue || this.asyncJobIdValue.equals(other.asyncJobIdValue);
                }
                case COMPLETE: {
                    return this.completeValue == other.completeValue || this.completeValue.equals(other.completeValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<ShareFolderLaunch, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(ShareFolderLaunch.class, Deserializer.getTagMapping(), null, SharedFolderMetadata.class);
        }

        @Override
        public ShareFolderLaunch deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case ASYNC_JOB_ID: {
                    String value = null;
                    Deserializer.expectField(_p, "async_job_id");
                    value = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    return ShareFolderLaunch.asyncJobId(value);
                }
                case COMPLETE: {
                    SharedFolderMetadata value = null;
                    value = this.readCollapsedStructValue(SharedFolderMetadata.class, _p, _ctx);
                    return ShareFolderLaunch.complete(value);
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("complete", Tag.COMPLETE);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<ShareFolderLaunch> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(ShareFolderLaunch.class, SharedFolderMetadata.class);
        }

        @Override
        public void serialize(ShareFolderLaunch value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case ASYNC_JOB_ID: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "async_job_id");
                    g.writeObjectField("async_job_id", value.asyncJobIdValue);
                    g.writeEndObject();
                    break;
                }
                case COMPLETE: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "complete");
                    this.getUnwrappingSerializer(SharedFolderMetadata.class).serialize(value.completeValue, g, provider);
                    g.writeEndObject();
                }
            }
        }
    }

    public static enum Tag {
        ASYNC_JOB_ID,
        COMPLETE;

    }
}

