/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.sharing.AccessLevel;
import com.dropbox.core.v2.sharing.FolderPermission;
import com.dropbox.core.v2.sharing.FolderPolicy;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class SharedFolderMetadataBase {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final AccessLevel accessType;
    protected final boolean isTeamFolder;
    protected final FolderPolicy policy;
    protected final List<FolderPermission> permissions;

    public SharedFolderMetadataBase(AccessLevel accessType, boolean isTeamFolder, FolderPolicy policy, List<FolderPermission> permissions) {
        if (accessType == null) {
            throw new IllegalArgumentException("Required value for 'accessType' is null");
        }
        this.accessType = accessType;
        this.isTeamFolder = isTeamFolder;
        if (policy == null) {
            throw new IllegalArgumentException("Required value for 'policy' is null");
        }
        this.policy = policy;
        if (permissions != null) {
            for (FolderPermission x : permissions) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'permissions' is null");
            }
        }
        this.permissions = permissions;
    }

    public SharedFolderMetadataBase(AccessLevel accessType, boolean isTeamFolder, FolderPolicy policy) {
        this(accessType, isTeamFolder, policy, null);
    }

    public AccessLevel getAccessType() {
        return this.accessType;
    }

    public boolean getIsTeamFolder() {
        return this.isTeamFolder;
    }

    public FolderPolicy getPolicy() {
        return this.policy;
    }

    public List<FolderPermission> getPermissions() {
        return this.permissions;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.accessType, this.isTeamFolder, this.policy, this.permissions});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            SharedFolderMetadataBase other = (SharedFolderMetadataBase)obj;
            return !(this.accessType != other.accessType && !this.accessType.equals((Object)other.accessType) || this.isTeamFolder != other.isTeamFolder || this.policy != other.policy && !this.policy.equals(other.policy) || this.permissions != other.permissions && (this.permissions == null || !this.permissions.equals(other.permissions)));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<SharedFolderMetadataBase> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(SharedFolderMetadataBase.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(SharedFolderMetadataBase.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<SharedFolderMetadataBase> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public SharedFolderMetadataBase deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            AccessLevel accessType = null;
            Boolean isTeamFolder = null;
            FolderPolicy policy = null;
            ArrayList<FolderPermission> permissions = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("access_type".equals(_field)) {
                    accessType = _p.readValueAs(AccessLevel.class);
                    _p.nextToken();
                    continue;
                }
                if ("is_team_folder".equals(_field)) {
                    isTeamFolder = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("policy".equals(_field)) {
                    policy = _p.readValueAs(FolderPolicy.class);
                    _p.nextToken();
                    continue;
                }
                if ("permissions".equals(_field)) {
                    Deserializer.expectArrayStart(_p);
                    permissions = new ArrayList<FolderPermission>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        FolderPermission _x = null;
                        _x = _p.readValueAs(FolderPermission.class);
                        _p.nextToken();
                        permissions.add(_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (accessType == null) {
                throw new JsonParseException(_p, "Required field \"access_type\" is missing.");
            }
            if (isTeamFolder == null) {
                throw new JsonParseException(_p, "Required field \"is_team_folder\" is missing.");
            }
            if (policy == null) {
                throw new JsonParseException(_p, "Required field \"policy\" is missing.");
            }
            return new SharedFolderMetadataBase(accessType, isTeamFolder, policy, permissions);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<SharedFolderMetadataBase> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(SharedFolderMetadataBase.class);
        }

        public Serializer(boolean unwrapping) {
            super(SharedFolderMetadataBase.class, unwrapping);
        }

        @Override
        protected JsonSerializer<SharedFolderMetadataBase> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(SharedFolderMetadataBase value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("access_type", (Object)value.accessType);
            g.writeObjectField("is_team_folder", value.isTeamFolder);
            g.writeObjectField("policy", value.policy);
            if (value.permissions != null) {
                g.writeObjectField("permissions", value.permissions);
            }
        }
    }
}

