/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.sharing.FileLinkMetadata;
import com.dropbox.core.v2.sharing.FolderLinkMetadata;
import com.dropbox.core.v2.sharing.LinkPermissions;
import com.dropbox.core.v2.sharing.TeamMemberInfo;
import com.dropbox.core.v2.users.Team;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class SharedLinkMetadata {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String url;
    protected final String id;
    protected final String name;
    protected final Date expires;
    protected final String pathLower;
    protected final LinkPermissions linkPermissions;
    protected final TeamMemberInfo teamMemberInfo;
    protected final Team contentOwnerTeamInfo;

    public SharedLinkMetadata(String url, String name, LinkPermissions linkPermissions, String id, Date expires, String pathLower, TeamMemberInfo teamMemberInfo, Team contentOwnerTeamInfo) {
        if (url == null) {
            throw new IllegalArgumentException("Required value for 'url' is null");
        }
        this.url = url;
        if (id != null && id.length() < 1) {
            throw new IllegalArgumentException("String 'id' is shorter than 1");
        }
        this.id = id;
        if (name == null) {
            throw new IllegalArgumentException("Required value for 'name' is null");
        }
        this.name = name;
        this.expires = expires;
        this.pathLower = pathLower;
        if (linkPermissions == null) {
            throw new IllegalArgumentException("Required value for 'linkPermissions' is null");
        }
        this.linkPermissions = linkPermissions;
        this.teamMemberInfo = teamMemberInfo;
        this.contentOwnerTeamInfo = contentOwnerTeamInfo;
    }

    public SharedLinkMetadata(String url, String name, LinkPermissions linkPermissions) {
        this(url, name, linkPermissions, null, null, null, null, null);
    }

    public String getUrl() {
        return this.url;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Date getExpires() {
        return this.expires;
    }

    public String getPathLower() {
        return this.pathLower;
    }

    public LinkPermissions getLinkPermissions() {
        return this.linkPermissions;
    }

    public TeamMemberInfo getTeamMemberInfo() {
        return this.teamMemberInfo;
    }

    public Team getContentOwnerTeamInfo() {
        return this.contentOwnerTeamInfo;
    }

    public static Builder newBuilder(String url, String name, LinkPermissions linkPermissions) {
        return new Builder(url, name, linkPermissions);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.url, this.id, this.name, this.expires, this.pathLower, this.linkPermissions, this.teamMemberInfo, this.contentOwnerTeamInfo});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            SharedLinkMetadata other = (SharedLinkMetadata)obj;
            return !(this.url != other.url && !this.url.equals(other.url) || this.name != other.name && !this.name.equals(other.name) || this.linkPermissions != other.linkPermissions && !this.linkPermissions.equals(other.linkPermissions) || this.id != other.id && (this.id == null || !this.id.equals(other.id)) || this.expires != other.expires && (this.expires == null || !this.expires.equals(other.expires)) || this.pathLower != other.pathLower && (this.pathLower == null || !this.pathLower.equals(other.pathLower)) || this.teamMemberInfo != other.teamMemberInfo && (this.teamMemberInfo == null || !this.teamMemberInfo.equals(other.teamMemberInfo)) || this.contentOwnerTeamInfo != other.contentOwnerTeamInfo && (this.contentOwnerTeamInfo == null || !this.contentOwnerTeamInfo.equals(other.contentOwnerTeamInfo)));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<SharedLinkMetadata> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(SharedLinkMetadata.class, FileLinkMetadata.class, FolderLinkMetadata.class);
        }

        public Deserializer(boolean unwrapping) {
            super(SharedLinkMetadata.class, unwrapping, FileLinkMetadata.class, FolderLinkMetadata.class);
        }

        @Override
        protected JsonDeserializer<SharedLinkMetadata> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public SharedLinkMetadata deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String _subtype_tag = Deserializer.readEnumeratedSubtypeTag(_p, new String[0]);
            if ("file".equals(_subtype_tag)) {
                return this.readCollapsedStructValue(FileLinkMetadata.class, _p, _ctx);
            }
            if ("folder".equals(_subtype_tag)) {
                return this.readCollapsedStructValue(FolderLinkMetadata.class, _p, _ctx);
            }
            String url = null;
            String name = null;
            LinkPermissions linkPermissions = null;
            String id = null;
            Date expires = null;
            String pathLower = null;
            TeamMemberInfo teamMemberInfo = null;
            Team contentOwnerTeamInfo = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("url".equals(_field)) {
                    url = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("name".equals(_field)) {
                    name = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("link_permissions".equals(_field)) {
                    linkPermissions = _p.readValueAs(LinkPermissions.class);
                    _p.nextToken();
                    continue;
                }
                if ("id".equals(_field)) {
                    id = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("expires".equals(_field)) {
                    expires = _ctx.parseDate(Deserializer.getStringValue(_p));
                    _p.nextToken();
                    continue;
                }
                if ("path_lower".equals(_field)) {
                    pathLower = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("team_member_info".equals(_field)) {
                    teamMemberInfo = _p.readValueAs(TeamMemberInfo.class);
                    _p.nextToken();
                    continue;
                }
                if ("content_owner_team_info".equals(_field)) {
                    contentOwnerTeamInfo = _p.readValueAs(Team.class);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (url == null) {
                throw new JsonParseException(_p, "Required field \"url\" is missing.");
            }
            if (name == null) {
                throw new JsonParseException(_p, "Required field \"name\" is missing.");
            }
            if (linkPermissions == null) {
                throw new JsonParseException(_p, "Required field \"link_permissions\" is missing.");
            }
            return new SharedLinkMetadata(url, name, linkPermissions, id, expires, pathLower, teamMemberInfo, contentOwnerTeamInfo);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<SharedLinkMetadata> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(SharedLinkMetadata.class);
        }

        public Serializer(boolean unwrapping) {
            super(SharedLinkMetadata.class, unwrapping);
        }

        @Override
        protected void serializeFields(SharedLinkMetadata value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("url", value.url);
            g.writeObjectField("name", value.name);
            g.writeObjectField("link_permissions", value.linkPermissions);
            if (value.id != null) {
                g.writeObjectField("id", value.id);
            }
            if (value.expires != null) {
                g.writeObjectField("expires", value.expires);
            }
            if (value.pathLower != null) {
                g.writeObjectField("path_lower", value.pathLower);
            }
            if (value.teamMemberInfo != null) {
                g.writeObjectField("team_member_info", value.teamMemberInfo);
            }
            if (value.contentOwnerTeamInfo != null) {
                g.writeObjectField("content_owner_team_info", value.contentOwnerTeamInfo);
            }
        }
    }

    public static class Builder {
        protected final String url;
        protected final String name;
        protected final LinkPermissions linkPermissions;
        protected String id;
        protected Date expires;
        protected String pathLower;
        protected TeamMemberInfo teamMemberInfo;
        protected Team contentOwnerTeamInfo;

        protected Builder(String url, String name, LinkPermissions linkPermissions) {
            if (url == null) {
                throw new IllegalArgumentException("Required value for 'url' is null");
            }
            this.url = url;
            if (name == null) {
                throw new IllegalArgumentException("Required value for 'name' is null");
            }
            this.name = name;
            if (linkPermissions == null) {
                throw new IllegalArgumentException("Required value for 'linkPermissions' is null");
            }
            this.linkPermissions = linkPermissions;
            this.id = null;
            this.expires = null;
            this.pathLower = null;
            this.teamMemberInfo = null;
            this.contentOwnerTeamInfo = null;
        }

        public Builder withId(String id) {
            if (id != null && id.length() < 1) {
                throw new IllegalArgumentException("String 'id' is shorter than 1");
            }
            this.id = id;
            return this;
        }

        public Builder withExpires(Date expires) {
            this.expires = expires;
            return this;
        }

        public Builder withPathLower(String pathLower) {
            this.pathLower = pathLower;
            return this;
        }

        public Builder withTeamMemberInfo(TeamMemberInfo teamMemberInfo) {
            this.teamMemberInfo = teamMemberInfo;
            return this;
        }

        public Builder withContentOwnerTeamInfo(Team contentOwnerTeamInfo) {
            this.contentOwnerTeamInfo = contentOwnerTeamInfo;
            return this;
        }

        public SharedLinkMetadata build() {
            return new SharedLinkMetadata(this.url, this.name, this.linkPermissions, this.id, this.expires, this.pathLower, this.teamMemberInfo, this.contentOwnerTeamInfo);
        }
    }
}

