/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.sharing.RequestedVisibility;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class SharedLinkSettings {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final RequestedVisibility requestedVisibility;
    protected final String linkPassword;
    protected final Date expires;

    public SharedLinkSettings(RequestedVisibility requestedVisibility, String linkPassword, Date expires) {
        this.requestedVisibility = requestedVisibility;
        this.linkPassword = linkPassword;
        this.expires = expires;
    }

    public SharedLinkSettings() {
        this(null, null, null);
    }

    public RequestedVisibility getRequestedVisibility() {
        return this.requestedVisibility;
    }

    public String getLinkPassword() {
        return this.linkPassword;
    }

    public Date getExpires() {
        return this.expires;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.requestedVisibility, this.linkPassword, this.expires});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            SharedLinkSettings other = (SharedLinkSettings)obj;
            return (this.requestedVisibility == other.requestedVisibility || this.requestedVisibility != null && this.requestedVisibility.equals((Object)other.requestedVisibility)) && (this.linkPassword == other.linkPassword || this.linkPassword != null && this.linkPassword.equals(other.linkPassword)) && (this.expires == other.expires || this.expires != null && this.expires.equals(other.expires));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<SharedLinkSettings> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(SharedLinkSettings.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(SharedLinkSettings.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<SharedLinkSettings> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public SharedLinkSettings deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            RequestedVisibility requestedVisibility = null;
            String linkPassword = null;
            Date expires = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("requested_visibility".equals(_field)) {
                    requestedVisibility = _p.readValueAs(RequestedVisibility.class);
                    _p.nextToken();
                    continue;
                }
                if ("link_password".equals(_field)) {
                    linkPassword = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("expires".equals(_field)) {
                    expires = _ctx.parseDate(Deserializer.getStringValue(_p));
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            return new SharedLinkSettings(requestedVisibility, linkPassword, expires);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<SharedLinkSettings> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(SharedLinkSettings.class);
        }

        public Serializer(boolean unwrapping) {
            super(SharedLinkSettings.class, unwrapping);
        }

        @Override
        protected JsonSerializer<SharedLinkSettings> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(SharedLinkSettings value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            if (value.requestedVisibility != null) {
                g.writeObjectField("requested_visibility", (Object)value.requestedVisibility);
            }
            if (value.linkPassword != null) {
                g.writeObjectField("link_password", value.linkPassword);
            }
            if (value.expires != null) {
                g.writeObjectField("expires", value.expires);
            }
        }
    }

    public static class Builder {
        protected RequestedVisibility requestedVisibility = null;
        protected String linkPassword = null;
        protected Date expires = null;

        protected Builder() {
        }

        public Builder withRequestedVisibility(RequestedVisibility requestedVisibility) {
            this.requestedVisibility = requestedVisibility;
            return this;
        }

        public Builder withLinkPassword(String linkPassword) {
            this.linkPassword = linkPassword;
            return this;
        }

        public Builder withExpires(Date expires) {
            this.expires = expires;
            return this;
        }

        public SharedLinkSettings build() {
            return new SharedLinkSettings(this.requestedVisibility, this.linkPassword, this.expires);
        }
    }
}

