/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.users.Team;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class TeamMemberInfo {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final Team teamInfo;
    protected final String displayName;
    protected final String memberId;

    public TeamMemberInfo(Team teamInfo, String displayName, String memberId) {
        if (teamInfo == null) {
            throw new IllegalArgumentException("Required value for 'teamInfo' is null");
        }
        this.teamInfo = teamInfo;
        if (displayName == null) {
            throw new IllegalArgumentException("Required value for 'displayName' is null");
        }
        this.displayName = displayName;
        this.memberId = memberId;
    }

    public TeamMemberInfo(Team teamInfo, String displayName) {
        this(teamInfo, displayName, null);
    }

    public Team getTeamInfo() {
        return this.teamInfo;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.teamInfo, this.displayName, this.memberId});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            TeamMemberInfo other = (TeamMemberInfo)obj;
            return !(this.teamInfo != other.teamInfo && !this.teamInfo.equals(other.teamInfo) || this.displayName != other.displayName && !this.displayName.equals(other.displayName) || this.memberId != other.memberId && (this.memberId == null || !this.memberId.equals(other.memberId)));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<TeamMemberInfo> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(TeamMemberInfo.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(TeamMemberInfo.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<TeamMemberInfo> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public TeamMemberInfo deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            Team teamInfo = null;
            String displayName = null;
            String memberId = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("team_info".equals(_field)) {
                    teamInfo = _p.readValueAs(Team.class);
                    _p.nextToken();
                    continue;
                }
                if ("display_name".equals(_field)) {
                    displayName = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("member_id".equals(_field)) {
                    memberId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (teamInfo == null) {
                throw new JsonParseException(_p, "Required field \"team_info\" is missing.");
            }
            if (displayName == null) {
                throw new JsonParseException(_p, "Required field \"display_name\" is missing.");
            }
            return new TeamMemberInfo(teamInfo, displayName, memberId);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<TeamMemberInfo> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(TeamMemberInfo.class);
        }

        public Serializer(boolean unwrapping) {
            super(TeamMemberInfo.class, unwrapping);
        }

        @Override
        protected JsonSerializer<TeamMemberInfo> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(TeamMemberInfo value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("team_info", value.teamInfo);
            g.writeObjectField("display_name", value.displayName);
            if (value.memberId != null) {
                g.writeObjectField("member_id", value.memberId);
            }
        }
    }
}

