/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.team.DeviceSession;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class ActiveWebSession
extends DeviceSession {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String userAgent;
    protected final String os;
    protected final String browser;

    public ActiveWebSession(String sessionId, String userAgent, String os, String browser, String ipAddress, String country, Date created, Date updated) {
        super(sessionId, ipAddress, country, created, updated);
        if (userAgent == null) {
            throw new IllegalArgumentException("Required value for 'userAgent' is null");
        }
        this.userAgent = userAgent;
        if (os == null) {
            throw new IllegalArgumentException("Required value for 'os' is null");
        }
        this.os = os;
        if (browser == null) {
            throw new IllegalArgumentException("Required value for 'browser' is null");
        }
        this.browser = browser;
    }

    public ActiveWebSession(String sessionId, String userAgent, String os, String browser) {
        this(sessionId, userAgent, os, browser, null, null, null, null);
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getOs() {
        return this.os;
    }

    public String getBrowser() {
        return this.browser;
    }

    public static Builder newBuilder(String sessionId, String userAgent, String os, String browser) {
        return new Builder(sessionId, userAgent, os, browser);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.userAgent, this.os, this.browser});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            ActiveWebSession other = (ActiveWebSession)obj;
            return !(this.sessionId != other.sessionId && !this.sessionId.equals(other.sessionId) || this.userAgent != other.userAgent && !this.userAgent.equals(other.userAgent) || this.os != other.os && !this.os.equals(other.os) || this.browser != other.browser && !this.browser.equals(other.browser) || this.ipAddress != other.ipAddress && (this.ipAddress == null || !this.ipAddress.equals(other.ipAddress)) || this.country != other.country && (this.country == null || !this.country.equals(other.country)) || this.created != other.created && (this.created == null || !this.created.equals(other.created)) || this.updated != other.updated && (this.updated == null || !this.updated.equals(other.updated)));
        }
        return false;
    }

    @Override
    public String toString() {
        return this.serialize(false);
    }

    @Override
    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<ActiveWebSession> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(ActiveWebSession.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(ActiveWebSession.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<ActiveWebSession> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public ActiveWebSession deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String sessionId = null;
            String userAgent = null;
            String os = null;
            String browser = null;
            String ipAddress = null;
            String country = null;
            Date created = null;
            Date updated = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("session_id".equals(_field)) {
                    sessionId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("user_agent".equals(_field)) {
                    userAgent = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("os".equals(_field)) {
                    os = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("browser".equals(_field)) {
                    browser = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("ip_address".equals(_field)) {
                    ipAddress = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("country".equals(_field)) {
                    country = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("created".equals(_field)) {
                    created = _ctx.parseDate(Deserializer.getStringValue(_p));
                    _p.nextToken();
                    continue;
                }
                if ("updated".equals(_field)) {
                    updated = _ctx.parseDate(Deserializer.getStringValue(_p));
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (sessionId == null) {
                throw new JsonParseException(_p, "Required field \"session_id\" is missing.");
            }
            if (userAgent == null) {
                throw new JsonParseException(_p, "Required field \"user_agent\" is missing.");
            }
            if (os == null) {
                throw new JsonParseException(_p, "Required field \"os\" is missing.");
            }
            if (browser == null) {
                throw new JsonParseException(_p, "Required field \"browser\" is missing.");
            }
            return new ActiveWebSession(sessionId, userAgent, os, browser, ipAddress, country, created, updated);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<ActiveWebSession> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(ActiveWebSession.class);
        }

        public Serializer(boolean unwrapping) {
            super(ActiveWebSession.class, unwrapping);
        }

        @Override
        protected JsonSerializer<ActiveWebSession> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(ActiveWebSession value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("session_id", value.sessionId);
            g.writeObjectField("user_agent", value.userAgent);
            g.writeObjectField("os", value.os);
            g.writeObjectField("browser", value.browser);
            if (value.ipAddress != null) {
                g.writeObjectField("ip_address", value.ipAddress);
            }
            if (value.country != null) {
                g.writeObjectField("country", value.country);
            }
            if (value.created != null) {
                g.writeObjectField("created", value.created);
            }
            if (value.updated != null) {
                g.writeObjectField("updated", value.updated);
            }
        }
    }

    public static class Builder
    extends DeviceSession.Builder {
        protected final String userAgent;
        protected final String os;
        protected final String browser;

        protected Builder(String sessionId, String userAgent, String os, String browser) {
            super(sessionId);
            if (userAgent == null) {
                throw new IllegalArgumentException("Required value for 'userAgent' is null");
            }
            this.userAgent = userAgent;
            if (os == null) {
                throw new IllegalArgumentException("Required value for 'os' is null");
            }
            this.os = os;
            if (browser == null) {
                throw new IllegalArgumentException("Required value for 'browser' is null");
            }
            this.browser = browser;
        }

        @Override
        public ActiveWebSession build() {
            return new ActiveWebSession(this.sessionId, this.userAgent, this.os, this.browser, this.ipAddress, this.country, this.created, this.updated);
        }
    }
}

